/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="concoction", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ConcoctionHUDOverlays {
    public static int healthIconsOffset;
    public static int foodIconsOffset;
    private static final ResourceLocation MOD_ICONS_TEXTURE;

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        ConcoctionHUDOverlays.register(event);
    }

    public static void register(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.PLAYER_HEALTH, ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"health_overlay"), (guiGraphics, deltaTracker) -> {
            healthIconsOffset = Minecraft.getInstance().gui.leftHeight;
        });
        event.registerBelow(VanillaGuiLayers.FOOD_LEVEL, ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"food_overlay"), (guiGraphics, deltaTracker) -> {
            foodIconsOffset = Minecraft.getInstance().gui.rightHeight;
        });
        event.registerAbove(VanillaGuiLayers.PLAYER_HEALTH, SpicyHeartsOverlay.ID, (LayeredDraw.Layer)new SpicyHeartsOverlay());
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, PhotosynthesisOverlay.ID, (LayeredDraw.Layer)new PhotosynthesisOverlay());
        event.registerAbove(VanillaGuiLayers.PLAYER_HEALTH, SunstruckHeartsOverlay.ID, (LayeredDraw.Layer)new SunstruckHeartsOverlay());
    }

    public static void drawPhotosynthesisOverlay(FoodData foodData, Minecraft minecraft, GuiGraphics graphics, int right, int top, boolean naturalHealing) {
        float saturation = foodData.getSaturationLevel();
        int foodLevel = foodData.getFoodLevel();
        int ticks = minecraft.gui.getGuiTicks();
        Random rand = new Random(ticks * 312871);
        RenderSystem.enableBlend();
        for (int j = 0; j < 10; ++j) {
            int x = right - j * 8 - 9;
            int y = top;
            if (saturation <= 0.0f && ticks % (foodLevel * 3 + 1) == 0) {
                y = top + (rand.nextInt(3) - 1);
            }
            graphics.blit(MOD_ICONS_TEXTURE, x, y, 0, 0, 9, 9);
            float effectiveHungerOfBar = (float)foodLevel / 2.0f - (float)j;
            if (effectiveHungerOfBar >= 1.0f) {
                graphics.blit(MOD_ICONS_TEXTURE, x, y, 18, 0, 9, 9);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            graphics.blit(MOD_ICONS_TEXTURE, x, y, 9, 0, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    public static void drawCustomHeartsOverlay(Player player, Minecraft minecraft, GuiGraphics graphics, int xBasePos, int yBasePos, HeartType container, HeartType regularFill, HeartType absorptionFill) {
        int ticks = minecraft.gui.getGuiTicks();
        Random rand = new Random((long)ticks * 312871L);
        int health = Mth.ceil((float)player.getHealth());
        float absorption = player.getAbsorptionAmount();
        float healthMax = (float)player.getAttribute(Attributes.MAX_HEALTH).getValue();
        int regenIndex = player.hasEffect(MobEffects.REGENERATION) ? ticks % Mth.ceil((float)healthMax) : -1;
        int totalHearts = Mth.ceil((float)(healthMax / 2.0f));
        int absorptionHearts = Mth.ceil((float)(absorption / 2.0f));
        int rowCount = Mth.ceil((float)((float)(totalHearts + absorptionHearts) / 10.0f));
        int rowHeight = Math.max(10 - (rowCount - 2), 3);
        for (int i = 0; i < totalHearts + absorptionHearts; ++i) {
            HeartType fillType;
            int row = i / 10;
            int col = i % 10;
            int x = xBasePos + col * 8;
            int y = yBasePos - row * rowHeight;
            if ((float)health + absorption <= 4.0f && row == 0) {
                y += rand.nextInt(2);
            }
            boolean isAbsorption = i >= totalHearts;
            boolean isBlinking = player.invulnerableTime > 0 && ticks % 6 < 3;
            boolean isHalf = false;
            int heartIndex = i * 2;
            HeartType heartType = fillType = isAbsorption ? absorptionFill : regularFill;
            if (!isAbsorption && heartIndex / 2 == regenIndex) {
                y -= 2;
            }
            ConcoctionHUDOverlays.renderHeart(graphics, container, x, y, false, isBlinking && !isAbsorption);
            if (isAbsorption) {
                float absorptionLeft = absorption - (float)((i - totalHearts) * 2);
                if (absorptionLeft >= 1.0f) {
                    ConcoctionHUDOverlays.renderHeart(graphics, fillType, x, y, false, false);
                    continue;
                }
                if (!(absorptionLeft > 0.0f)) continue;
                ConcoctionHUDOverlays.renderHeart(graphics, fillType, x, y, true, false);
                continue;
            }
            float healthLeft = health - heartIndex;
            if (isBlinking && (float)heartIndex < healthMax) {
                isHalf = (float)(heartIndex + 1) == healthMax;
                ConcoctionHUDOverlays.renderHeart(graphics, fillType, x, y, isHalf, true);
            }
            if (healthLeft >= 2.0f) {
                ConcoctionHUDOverlays.renderHeart(graphics, fillType, x, y, false, false);
                continue;
            }
            if (healthLeft != 1.0f) continue;
            ConcoctionHUDOverlays.renderHeart(graphics, fillType, x, y, true, false);
        }
    }

    private static void renderHeart(GuiGraphics guiGraphics, HeartType heartType, int x, int y, boolean isHalf, boolean isBlinking) {
        RenderSystem.enableBlend();
        guiGraphics.blitSprite(heartType.getSprite(isHalf, isBlinking), x, y, 9, 9);
        RenderSystem.disableBlend();
    }

    static {
        MOD_ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"textures/gui/hud/concoction_gui_icons.png");
    }

    public static class SpicyHeartsOverlay
    extends BaseOverlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"spicy_hearts");

        @Override
        public void render(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            if (player.hasEffect(ConcoctionModMobEffects.SPICY)) {
                ConcoctionHUDOverlays.drawCustomHeartsOverlay(player, minecraft, guiGraphics, left, top - healthIconsOffset, HeartType.CONTAINER_SPICY, HeartType.SPICY, HeartType.SPICY_ABSORB);
            }
        }
    }

    public static class PhotosynthesisOverlay
    extends BaseOverlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"photosynthesis");

        @Override
        public void render(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            int dayTime;
            boolean isPlayerHealingWithSaturation;
            FoodData stats = player.getFoodData();
            boolean bl = isPlayerHealingWithSaturation = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && player.isHurt() && stats.getFoodLevel() >= 18;
            if (player.hasEffect(ConcoctionModMobEffects.PHOTOSYNTHESIS) && ((dayTime = Math.floorMod(player.level().dayTime(), 24000)) >= 0 && dayTime < 13000 || dayTime >= 23000 && dayTime < 24000) && player.level().canSeeSky(player.blockPosition().above())) {
                ConcoctionHUDOverlays.drawPhotosynthesisOverlay(stats, minecraft, guiGraphics, right, top - foodIconsOffset, isPlayerHealingWithSaturation);
            }
        }
    }

    public static class SunstruckHeartsOverlay
    extends BaseOverlay {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"sunstruck_hearts");

        @Override
        public void render(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int left, int right, int top, int guiTicks) {
            if (player.hasEffect(ConcoctionModMobEffects.SUNSTRUCK_EFFECT)) {
                ConcoctionHUDOverlays.drawCustomHeartsOverlay(player, minecraft, guiGraphics, left, top - healthIconsOffset, HeartType.CONTAINER_SUNSTRUCK, HeartType.SUNSTRUCK, HeartType.SUNSTRUCK_ABSORB);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum HeartType implements IExtensibleEnum
    {
        CONTAINER_SPICY(HeartType.sprite("hud/spicyheart/container"), HeartType.sprite("hud/spicyheart/container_blinking"), HeartType.sprite("hud/spicyheart/container"), HeartType.sprite("hud/spicyheart/container_blinking")),
        SPICY(HeartType.sprite("hud/spicyheart/full"), HeartType.sprite("hud/spicyheart/full_blinking"), HeartType.sprite("hud/spicyheart/half"), HeartType.sprite("hud/spicyheart/half_blinking")),
        SPICY_ABSORB(HeartType.sprite("hud/spicyheart/absorb_full"), HeartType.sprite("hud/spicyheart/absorb_full"), HeartType.sprite("hud/spicyheart/absorb_half"), HeartType.sprite("hud/spicyheart/absorb_half")),
        CONTAINER_SUNSTRUCK(HeartType.sprite("hud/sunstruckheart/container"), HeartType.sprite("hud/sunstruckheart/container_blinking"), HeartType.sprite("hud/sunstruckheart/container"), HeartType.sprite("hud/sunstruckheart/container_blinking")),
        SUNSTRUCK(HeartType.sprite("hud/sunstruckheart/full"), HeartType.sprite("hud/sunstruckheart/full_blinking"), HeartType.sprite("hud/sunstruckheart/half"), HeartType.sprite("hud/sunstruckheart/half_blinking")),
        SUNSTRUCK_ABSORB(HeartType.sprite("hud/sunstruckheart/absorb_full"), HeartType.sprite("hud/sunstruckheart/absorb_full"), HeartType.sprite("hud/sunstruckheart/absorb_half"), HeartType.sprite("hud/sunstruckheart/absorb_half"));

        private final ResourceLocation full;
        private final ResourceLocation fullBlinking;
        private final ResourceLocation half;
        private final ResourceLocation halfBlinking;

        private HeartType(ResourceLocation full, ResourceLocation fullBlinking, ResourceLocation half, ResourceLocation halfBlinking) {
            this.full = full;
            this.fullBlinking = fullBlinking;
            this.half = half;
            this.halfBlinking = halfBlinking;
        }

        public ResourceLocation getSprite(boolean isHalf, boolean isBlinking) {
            return isHalf ? (isBlinking ? this.halfBlinking : this.half) : (isBlinking ? this.fullBlinking : this.full);
        }

        private static ResourceLocation sprite(String path) {
            return ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)path);
        }
    }

    public static abstract class BaseOverlay
    implements LayeredDraw.Layer {
        public abstract void render(Minecraft var1, Player var2, GuiGraphics var3, int var4, int var5, int var6, int var7);

        public final void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player == null || !this.shouldRenderOverlay(minecraft, (Player)minecraft.player, guiGraphics, minecraft.gui.getGuiTicks())) {
                return;
            }
            int top = guiGraphics.guiHeight();
            int left = guiGraphics.guiWidth() / 2 - 91;
            int right = guiGraphics.guiWidth() / 2 + 91;
            this.render(minecraft, (Player)minecraft.player, guiGraphics, left, right, top, minecraft.gui.getGuiTicks());
        }

        public boolean shouldRenderOverlay(Minecraft minecraft, Player player, GuiGraphics guiGraphics, int guiTicks) {
            return !minecraft.options.hideGui && minecraft.gameMode != null && minecraft.gameMode.canHurtPlayer();
        }
    }
}

