/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.compat;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.mcreator.concoction.compat.ButterChurnRecipeCategory;
import net.mcreator.concoction.compat.CauldronRecipeCategory;
import net.mcreator.concoction.compat.OvenRecipeCategory;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.init.ConcoctionModRecipes;
import net.mcreator.concoction.recipe.butterChurn.ButterChurnRecipe;
import net.mcreator.concoction.recipe.cauldron.CauldronBrewingRecipe;
import net.mcreator.concoction.recipe.oven.OvenRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ButterChurnRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OvenRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Objects.requireNonNull(Minecraft.getInstance().level);
        RecipeManager recipeManager = world.getRecipeManager();
        List<CauldronBrewingRecipe> cookingCauldronRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ConcoctionModRecipes.CAULDRON_BREWING_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(CauldronRecipeCategory.CAULDRON_RECIPE_TYPE, cookingCauldronRecipes);
        List<ButterChurnRecipe> butterChurnRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ConcoctionModRecipes.BUTTER_CHURN_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(ButterChurnRecipeCategory.BUTTER_CHURN_RECIPE_TYPE, butterChurnRecipes);
        List<OvenRecipe> ovenRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ConcoctionModRecipes.OVEN_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(OvenRecipeCategory.OVEN_RECIPE_TYPE, ovenRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ConcoctionModItems.BUTTER_CHURN.get()), new RecipeType[]{ButterChurnRecipeCategory.BUTTER_CHURN_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.CAULDRON), new RecipeType[]{CauldronRecipeCategory.CAULDRON_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ConcoctionModItems.OVEN.get()), new RecipeType[]{OvenRecipeCategory.OVEN_RECIPE_TYPE});
    }
}

