/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.custom;

import java.util.Comparator;
import java.util.Optional;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class BeeFollowPlayerGoal
extends Goal {
    private Bee bee;
    private Optional<LivingEntity> target;

    public BeeFollowPlayerGoal(Bee bee) {
        this.bee = bee;
    }

    public boolean canUse() {
        Level level = this.bee.level();
        if (level.isClientSide()) {
            return false;
        }
        AABB aabb = this.bee.getBoundingBox();
        this.target = level.getEntitiesOfClass(LivingEntity.class, aabb.inflate(8.0), livingEntity -> livingEntity.hasEffect(ConcoctionModMobEffects.SWEETNESS)).stream().min(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)this.bee)));
        return this.target.isPresent();
    }

    public void tick() {
        this.target.ifPresent(livingEntity -> this.bee.getNavigation().moveTo(livingEntity.getX(), livingEntity.getY() + 1.4, livingEntity.getZ(), 1.0));
    }
}

