/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.custom;

import java.util.Comparator;
import java.util.Optional;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class FollowSaltyPlayerGoal
extends Goal {
    private final Mob mob;
    private Optional<LivingEntity> target = Optional.empty();

    public FollowSaltyPlayerGoal(Mob mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        Level level = this.mob.level();
        if (level.isClientSide()) {
            return false;
        }
        AABB aabb = this.mob.getBoundingBox().inflate(8.0);
        this.target = level.getEntitiesOfClass(LivingEntity.class, aabb, livingEntity -> livingEntity.hasEffect(ConcoctionModMobEffects.SALTNESS)).stream().min(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)this.mob)));
        return this.target.isPresent();
    }

    public void tick() {
        this.target.ifPresent(livingEntity -> this.mob.getNavigation().moveTo(livingEntity.getX(), livingEntity.getY() + 1.0, livingEntity.getZ(), 1.1));
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }
}

