/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.player.Player;

public class FollowSaltyPlayerTask<E extends LivingEntity>
extends Behavior<E> {
    private final float speedModifier;
    private Player targetPlayer;
    private final Predicate<Player> followPredicate = player -> player != null && player.isAlive() && player.hasEffect(ConcoctionModMobEffects.SALTNESS);

    public FollowSaltyPlayerTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = 1.1f;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        Optional optionalPlayer = pLevel.getEntitiesOfClass(Player.class, pOwner.getBoundingBox().inflate(10.0), this.followPredicate).stream().findFirst();
        if (optionalPlayer.isPresent()) {
            this.targetPlayer = (Player)optionalPlayer.get();
            return true;
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel pLevel, E pEntity, long pGameTime) {
        return this.targetPlayer != null && this.followPredicate.test(this.targetPlayer) && pEntity.distanceToSqr((Entity)this.targetPlayer) < 100.0;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        this.updateWalkAndLookTarget(pEntity);
    }

    protected void tick(ServerLevel pLevel, E pOwner, long pGameTime) {
        if (pOwner.distanceToSqr((Entity)this.targetPlayer) > 6.25) {
            this.updateWalkAndLookTarget(pOwner);
        }
    }

    private void updateWalkAndLookTarget(E entity) {
        Brain brain = entity.getBrain();
        brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.targetPlayer, true));
        brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)this.targetPlayer, this.speedModifier, 2));
    }

    protected void stop(ServerLevel pLevel, E pEntity, long pGameTime) {
        this.targetPlayer = null;
        pEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        pEntity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }
}

