/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.entity;

import net.mcreator.concoction.init.ConcoctionModEntities;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.jetbrains.annotations.NotNull;

public class SunstruckEntity
extends Zombie {
    private static final double DAY_SPEED_MULTIPLIER = 1.15;
    private static final double DAY_DAMAGE_MULTIPLIER = 2.0;
    private static final double NIGHT_DAMAGE_MULTIPLIER = 0.5;
    private static final double NIGHT_SPEED_MULTIPLIER = 1.0;
    private double baseSpeed;
    private double baseDamage;
    private boolean wasDay;

    public SunstruckEntity(EntityType<? extends Zombie> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setCanBreakDoors(true);
        this.baseSpeed = this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue();
        this.baseDamage = this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
        this.wasDay = this.level().isDay();
        this.updateAttributes();
    }

    public void tick() {
        super.tick();
        boolean isDay = this.level().isDay();
        if (isDay != this.wasDay && !this.level().isClientSide()) {
            this.wasDay = isDay;
            this.updateAttributes();
        }
    }

    private void updateAttributes() {
        boolean isDay = this.level().isDay();
        double speedMultiplier = isDay ? 1.15 : 1.0;
        double damageMultiplier = isDay ? 2.0 : 0.5;
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.baseSpeed * speedMultiplier);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.baseDamage * damageMultiplier);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (!this.level().isDay() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, amount * 2.0f);
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(Entity target) {
        float rand;
        LivingEntity livingTarget;
        boolean flag = super.doHurtTarget(target);
        if (flag && this.getMainHandItem().isEmpty() && target instanceof LivingEntity && !(livingTarget = (LivingEntity)target).level().isClientSide() && (rand = this.level().random.nextFloat()) <= 0.33f) {
            int currentAmplifier = 0;
            int maxAmplifier = 3;
            int baseDuration = 320;
            float difficultyMultiplier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            int duration = baseDuration * (int)difficultyMultiplier;
            MobEffectInstance existing = livingTarget.getEffect(ConcoctionModMobEffects.SUNSTRUCK_EFFECT);
            if (existing != null) {
                currentAmplifier = Math.min(existing.getAmplifier() + 1, maxAmplifier);
            }
            livingTarget.addEffect(new MobEffectInstance(ConcoctionModMobEffects.SUNSTRUCK_EFFECT, duration, currentAmplifier), (Entity)this);
        }
        return flag;
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean isSunSensitive() {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.zombie.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.zombie.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.zombie.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.zombie.death"));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ConcoctionModEntities.SUNSTRUCK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.STEP_HEIGHT, 0.6);
    }
}

