/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.init;

import net.mcreator.concoction.entity.CordycepsCaveSpiderEntity;
import net.mcreator.concoction.entity.CordycepsSpiderEntity;
import net.mcreator.concoction.entity.SunstruckEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ConcoctionModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"concoction");
    public static final DeferredHolder<EntityType<?>, EntityType<SunstruckEntity>> SUNSTRUCK = ConcoctionModEntities.register("sunstruck", EntityType.Builder.of(SunstruckEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CordycepsSpiderEntity>> CORDYCEPS_SPIDER = ConcoctionModEntities.register("cordyceps_spider", EntityType.Builder.of(CordycepsSpiderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.4f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<CordycepsCaveSpiderEntity>> CORDYCEPS_CAVE_SPIDER = ConcoctionModEntities.register("cordyceps_cave_spider", EntityType.Builder.of(CordycepsCaveSpiderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.7f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SunstruckEntity.init(event);
        CordycepsSpiderEntity.init(event);
        CordycepsCaveSpiderEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SUNSTRUCK.get(), SunstruckEntity.createAttributes().build());
        event.put((EntityType)CORDYCEPS_SPIDER.get(), CordycepsSpiderEntity.createAttributes().build());
        event.put((EntityType)CORDYCEPS_CAVE_SPIDER.get(), CordycepsCaveSpiderEntity.createAttributes().build());
    }
}

