/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.mixins;

import java.util.Objects;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.mcreator.concoction.interfaces.IPlayerUnsuccessfulAttempts;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements IPlayerUnsuccessfulAttempts {
    @Unique
    private int concoction$unsuccessfulAttempts = 0;

    @Override
    @Unique
    public int concoction$getUnsuccessfulAttempts() {
        return this.concoction$unsuccessfulAttempts;
    }

    @Override
    @Unique
    public void concoction$setUnsuccessfulAttempts(int unsuccessfulAttempts) {
        this.concoction$unsuccessfulAttempts = unsuccessfulAttempts;
    }

    @Override
    @Unique
    public void concoction$incrementUnsuccessfulAttempts() {
        ++this.concoction$unsuccessfulAttempts;
    }

    @Override
    @Unique
    public void concoction$decrementUnsuccessfulAttempts() {
        --this.concoction$unsuccessfulAttempts;
    }

    @Inject(method={"eat"}, at={@At(value="RETURN")})
    private void concoction$applySaltnessFoodBoost(Level pLevel, ItemStack pFood, FoodProperties pFoodProperties, CallbackInfoReturnable<ItemStack> cir) {
        TagKey drinkTag;
        Player player = (Player)this;
        MobEffectInstance saltnessEffect = player.getEffect(ConcoctionModMobEffects.SALTNESS);
        if (saltnessEffect != null && pFood.is(drinkTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:foods/drink")))) {
            int amplifier = saltnessEffect.getAmplifier();
            int hungerBonus = 2;
            float saturationBonus = 3.0f + (float)amplifier * 1.5f;
            player.getFoodData().eat(hungerBonus, 0.0f);
            float currentSaturation = player.getFoodData().getSaturationLevel();
            float newSaturation = Math.min(currentSaturation + saturationBonus, 20.0f);
            player.getFoodData().setSaturation(newSaturation);
        }
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"))
    private void onEat(Level instance, Player player, double p_46544_, double p_46545_, double p_46546_, SoundEvent p_46547_, SoundSource p_46548_, float p_46549_, float p_46550_, Level pLevel, ItemStack itemStack, FoodProperties foodProperties) {
        if (itemStack.getItem().equals(ConcoctionModItems.MINT_BREW.get()) || itemStack.getItem().equals(ConcoctionModItems.OBSIDIAN_TEARS_BOTTLE.get()) || itemStack.getItem().equals(ConcoctionModItems.HOT_SAUCE_BOTTLE.get())) {
            instance.playSound(player, p_46544_, p_46545_, p_46546_, Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"concoction:silence"))), p_46548_, p_46549_, p_46550_);
        } else {
            instance.playSound(player, p_46544_, p_46545_, p_46546_, p_46547_, p_46548_, p_46549_, p_46550_);
        }
    }

    @Inject(method={"causeFoodExhaustion(F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;addExhaustion(F)V")}, cancellable=true)
    private void onCauseFoodExhaustion(float exhaustionValue, CallbackInfo ci) {
        int dayTime;
        Player player = (Player)this;
        if (player.hasEffect(ConcoctionModMobEffects.PHOTOSYNTHESIS) && ((dayTime = Math.floorMod(player.level().dayTime(), 24000)) >= 0 && dayTime < 13000 || dayTime >= 23000 && dayTime < 24000) && player.level().canSeeSky(player.blockPosition().above())) {
            int effectLevel = Objects.requireNonNull(player.getEffect(ConcoctionModMobEffects.PHOTOSYNTHESIS)).getAmplifier();
            player.getFoodData().addExhaustion(Math.max(exhaustionValue - exhaustionValue * (0.3f + (float)effectLevel * 0.2f), 0.0f));
            ci.cancel();
            return;
        }
        if (player.hasEffect(ConcoctionModMobEffects.BITTERNESS)) {
            int effectLevel = player.getEffect(ConcoctionModMobEffects.BITTERNESS).getAmplifier();
            float multiplier = 1.2f + 0.1f * (float)effectLevel;
            player.getFoodData().addExhaustion(exhaustionValue * multiplier);
            ci.cancel();
            return;
        }
    }

    @Inject(method={"canWalkOnPowderSnow"}, at={@At(value="HEAD")}, cancellable=true)
    private void concoction$warmingPowderSnowImmunity(CallbackInfoReturnable<Boolean> cir) {
        int amplifier;
        Player self = (Player)this;
        if (self.hasEffect(ConcoctionModMobEffects.WARMING) && (amplifier = self.getEffect(ConcoctionModMobEffects.WARMING).getAmplifier()) >= 2) {
            cir.setReturnValue((Object)true);
        }
    }
}

