/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction;

import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;

@EventBusSubscriber
public class LootHandler {
    @SubscribeEvent
    public static void LootTableLoad(LootTableLoadEvent event) {
        LootHandler.lootLoad(event.getName(), b -> event.getTable().addPool(b.build()));
    }

    public static void lootLoad(ResourceLocation id, Consumer<LootPool.Builder> addPool) {
        String file;
        String blockPrefix = "minecraft:blocks/";
        String entityPrefix = "minecraft:entities/";
        String name = id.toString();
        if (name.startsWith(entityPrefix)) {
            switch (file = name.substring(name.indexOf(entityPrefix) + entityPrefix.length())) {
                case "cow": 
                case "pig": 
                case "sheep": 
                case "chicken": 
                case "horse": 
                case "donkey": 
                case "mooshroom": 
                case "rabbit": 
                case "polar_bear": 
                case "llama": 
                case "hoglin": {
                    addPool.accept(LootHandler.getInjectPool("animal_fat"));
                    break;
                }
            }
        }
        if (name.startsWith(blockPrefix)) {
            switch (file = name.substring(name.indexOf(blockPrefix) + blockPrefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": {
                    addPool.accept(LootHandler.getInjectPool(file));
                    break;
                }
                case "village/village_temple": 
                case "village/village_toolsmith": 
                case "village/village_weaponsmith": {
                    addPool.accept(LootHandler.getInjectPool("village_chest"));
                    break;
                }
                case "cherry_leaves": {
                    addPool.accept(LootHandler.getInjectPool(file));
                    break;
                }
                case "spruce_leaves": {
                    addPool.accept(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private static LootPool.Builder getInjectPool(String entryName) {
        return LootPool.lootPool().add(LootHandler.getInjectEntry(entryName, 5));
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(String name, int weight) {
        return NestedLootTable.lootTableReference((ResourceKey)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)("inject/" + name)))).setWeight(weight);
    }
}

