/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import javax.annotation.Nullable;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class CropRiceBlock
extends CropBlock
implements SimpleWaterloggedBlock {
    public static final int FIRST_STAGE_MAX_AGE = 3;
    public static final int SECOND_STAGE_MAX_AGE = 2;
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)5);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CropRiceBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockState updateShape(BlockState p_56285_, Direction p_56286_, BlockState p_56287_, LevelAccessor p_56288_, BlockPos p_56289_, BlockPos p_56290_) {
        if (((Boolean)p_56285_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_56288_.scheduleTick(p_56289_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_56288_));
        }
        return super.updateShape(p_56285_, p_56286_, p_56287_, p_56288_, p_56289_, p_56290_);
    }

    protected FluidState getFluidState(BlockState p_56299_) {
        return (Boolean)p_56299_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_56299_);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            default -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 0 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
            case 1 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
            case 2 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 3 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
            case 4 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
            case 5 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, HALF, WATERLOGGED});
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return ((Integer)pState.getValue((Property)AGE)).intValue() != this.getMaxAge();
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource random) {
        float f;
        int nextAge;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.getRawBrightness(pPos, 0) >= 9 && pState.getValue(HALF) == DoubleBlockHalf.LOWER && (pLevel.getBlockState(pPos.above(1)).is(Blocks.AIR) || pLevel.getBlockState(pPos.above(1)).is((Block)this) && !((Boolean)pLevel.getBlockState(pPos.above(1)).getValue((Property)WATERLOGGED)).booleanValue()) && (nextAge = this.getAge(pState) + 1) <= this.getMaxAge() && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (random.nextInt((int)(25.0f / (f = CropRiceBlock.getGrowthSpeed((BlockState)pState, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (nextAge < 3) {
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (Boolean)pState.getValue((Property)WATERLOGGED)), 2);
            } else if (nextAge >= 3 && (pLevel.getBlockState(pPos.above(1)).is(Blocks.AIR) || pLevel.getBlockState(pPos.above(1)).is((Block)this))) {
                pLevel.setBlock(pPos.above(1), this.getState(pState, nextAge, DoubleBlockHalf.UPPER, false), 2);
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (Boolean)pState.getValue((Property)WATERLOGGED)), 2);
            }
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int nextAge = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        int maxAge = this.getMaxAge();
        if (pState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if (nextAge > maxAge) {
                nextAge = maxAge;
            }
            if (nextAge < 3) {
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (Boolean)pState.getValue((Property)WATERLOGGED)), 2);
            } else if (nextAge >= 3 && (pLevel.getBlockState(pPos.above(1)).is(Blocks.AIR) || pLevel.getBlockState(pPos.above(1)).is((Block)this))) {
                pLevel.setBlock(pPos.above(1), this.getState(pState, nextAge, DoubleBlockHalf.UPPER, false), 2);
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (Boolean)pState.getValue((Property)WATERLOGGED)), 2);
            }
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ConcoctionModItems.RICE.get());
    }

    public BlockState getState(BlockState pState, int age, DoubleBlockHalf half, boolean waterlogged) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue(HALF, (Comparable)half);
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        if (pState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return ((Integer)pState.getValue((Property)AGE)).intValue() != this.getMaxAge();
        }
        return false;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if ((Integer)pState.getValue((Property)AGE) >= 3) {
                return super.canSurvive(pState, pLevel, pPos) && pLevel.getBlockState(pPos.above(1)).is((Block)this) && (Boolean)pState.getValue((Property)WATERLOGGED) == true;
            }
            return super.canSurvive(pState, pLevel, pPos);
        }
        return super.canSurvive(pState, pLevel, pPos) || pLevel.getBlockState(pPos.below(1)).is((Block)this) && (Boolean)pState.getValue((Property)WATERLOGGED) == false && (Integer)pLevel.getBlockState(pPos.below(1)).getValue((Property)AGE) >= 3 && pLevel.getBlockState(pPos.below(1)).getValue(HALF) != pState.getValue(HALF);
    }

    public boolean mayPlaceOn(BlockState pState, BlockGetter blockGetter, BlockPos pPos) {
        return (pState.is(BlockTags.DIRT) || pState.is(BlockTags.SAND) || pState.is(Blocks.GRAVEL) || pState.is(Blocks.CLAY) || pState.is(Blocks.MUD)) && blockGetter.getBlockState(pPos.above()).getFluidState().is((Fluid)Fluids.WATER) && !(pState.getBlock() instanceof CropRiceBlock);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player player) {
        if (!pLevel.isClientSide) {
            if (player.isCreative()) {
                CropRiceBlock.breakBlock(false, pLevel, pPos, pState, player);
            } else {
                CropRiceBlock.breakBlock(true, pLevel, pPos, pState, player);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, player);
    }

    public void playerDestroy(Level p_52865_, Player p_52866_, BlockPos p_52867_, BlockState p_52868_, @Nullable BlockEntity p_52869_, ItemStack p_52870_) {
        super.playerDestroy(p_52865_, p_52866_, p_52867_, Blocks.AIR.defaultBlockState(), p_52869_, p_52870_);
    }

    protected static void breakBlock(boolean dropItems, Level pLevel, BlockPos pPos, BlockState pState, Player player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            BlockPos blockpos = pPos.below();
            BlockState blockstate = pLevel.getBlockState(blockpos);
            if (blockstate.is(pState.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
                BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                pLevel.setBlock(blockpos, blockstate1, 35);
                pLevel.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
                if (dropItems) {
                    CropRiceBlock.dropResources((BlockState)blockstate, (Level)pLevel, (BlockPos)blockpos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                }
            }
        } else if (dropItems) {
            CropRiceBlock.dropResources((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos()).getFluidState().is((Fluid)Fluids.WATER)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 25;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    public int getMaxAge() {
        return 5;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.RICE.get();
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }
}

