/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class MintBaleBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    private static final float MIN_FALL_DISTANCE = 1.0f;
    private static final int MINTY_BREATH_DURATION_TICKS = 200;
    private static final int MINTY_BREATH_AMPLIFIER = 0;
    private static final boolean MINTY_BREATH_AMBIENT = false;
    private static final boolean MINTY_BREATH_SHOW_PARTICLES = false;
    private static final boolean MINTY_BREATH_SHOW_ICON = true;

    public MintBaleBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).sound(SoundType.GRASS).strength(0.5f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 0.2f, world.damageSources().fall());
        if (!world.isClientSide && fallDistance >= 1.0f && entity instanceof LivingEntity) {
            ResourceKey key;
            Holder mintyHolder;
            LivingEntity living = (LivingEntity)entity;
            ResourceLocation id = ConcoctionModMobEffects.MINTY_BREATH.getId();
            if (id != null && (mintyHolder = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(key = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)id)).orElse(null)) != null) {
                MobEffectInstance effect = new MobEffectInstance(mintyHolder, 200, 0, false, false, true);
                living.addEffect(effect);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }
}

