/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import java.util.Objects;
import net.mcreator.concoction.block.SoullandBlock;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class NetherPepperCropBlock
extends CropBlock {
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)5);

    public NetherPepperCropBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).lightLevel(s -> 3).noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (!(worldIn instanceof LevelReader)) {
            return false;
        }
        return this.canSurvive(state, (LevelReader)worldIn, pos);
    }

    protected boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockBelow = pos.below();
        BlockState soil = worldIn.getBlockState(blockBelow);
        return soil.getBlock() instanceof SoullandBlock;
    }

    protected void randomTick(BlockState p_221050_, ServerLevel p_221051_, BlockPos p_221052_, RandomSource p_221053_) {
        super.randomTick(p_221050_, p_221051_, p_221052_, p_221053_);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        if (!world.isClientSide()) {
            ((ServerLevel)world).scheduleTick(pos, (Block)this, 1);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pItem, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand p_316595_, BlockHitResult p_316140_) {
        if (!pPlayer.isShiftKeyDown() && pState.getBlock() == ConcoctionModBlocks.NETHER_PEPPER_CROP.get() && (Integer)pState.getValue((Property)AGE) == 5) {
            pPlayer.swing(InteractionHand.MAIN_HAND, true);
            if (!pLevel.isClientSide()) {
                pLevel.playSound(null, pPos, Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.sweet_berry_bush.pick_berries"))), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                pLevel.playLocalSound(pPos, Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.sweet_berry_bush.pick_berries"))), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (pLevel instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)pLevel;
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 3);
                ItemEntity entityToSpawn = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.REAPPER.get(), 1));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
                if (Math.random() < 0.3) {
                    ItemEntity entityToSpawn3 = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.REAPPER.get()));
                    entityToSpawn3.setPickUpDelay(10);
                    _level.addFreshEntity((Entity)entityToSpawn3);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(pItem, pState, pLevel, pPos, pPlayer, p_316595_, p_316140_);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        long time = world.getDayTime() % 24000L;
        if (time >= 17950L && time <= 18050L) {
            for (Player player : world.getEntitiesOfClass(Player.class, new AABB(pos).inflate(8.0))) {
                if (!player.isAlive()) continue;
                player.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"concoction:soul_damage")))), 4.0f);
                double px = player.getX() + world.random.nextDouble() * 0.6 - 0.3;
                double py = player.getY() + (double)player.getBbHeight() * 0.5 + world.random.nextDouble() * 0.6 - 0.3;
                double pz = player.getZ() + world.random.nextDouble() * 0.6 - 0.3;
                double vx = world.random.nextDouble() * 0.26 - 0.13;
                double vy = world.random.nextDouble() * 0.07 + 0.13;
                double vz = world.random.nextDouble() * 0.26 - 0.13;
                world.sendParticles((ParticleOptions)ParticleTypes.SOUL, px, py, pz, 1, vx, vy, vz, 0.2);
            }
        }
        world.scheduleTick(pos, (Block)this, 20);
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            default -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 0 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
            case 1 -> Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
            case 2 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 3 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 4 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 5 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ConcoctionModItems.REAPPER_SEEDS.get());
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    public int getMaxAge() {
        return 5;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.REAPPER_SEEDS.get();
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        long time = world.dayTime() % 24000L;
        if (time >= 17950L && time <= 18050L) {
            Level _level;
            if (Math.random() < 0.65) {
                world.addParticle((ParticleOptions)ParticleTypes.SOUL, x + Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.2, (double)0.8), y + Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.2, (double)0.8), z + Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.2, (double)0.8), Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.13, (double)0.13), Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.13, (double)0.2), Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.13, (double)0.13));
            }
            if (Math.random() < 0.1 && world instanceof Level) {
                _level = world;
                ResourceLocation soulEscape = ResourceLocation.parse((String)"particle.soul_escape");
                float pitch = (float)(0.8 + Math.random() * 0.4);
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soulEscape), SoundSource.BLOCKS, 0.6f, pitch);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soulEscape), SoundSource.BLOCKS, 0.6f, pitch, false);
                }
            }
            if (Math.random() < 0.02 && world instanceof Level) {
                _level = world;
                float pitch = (float)(0.5 + Math.random() * 0.5);
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), SoundEvents.GHAST_HURT, SoundSource.HOSTILE, 0.4f, pitch);
                } else {
                    _level.playLocalSound(x, y, z, SoundEvents.GHAST_HURT, SoundSource.HOSTILE, 0.4f, pitch, false);
                }
            }
        }
    }
}

