/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SaponariaBlock
extends MultifaceBlock
implements BonemealableBlock {
    public static final MapCodec<SaponariaBlock> CODEC = SaponariaBlock.simpleCodec(SaponariaBlock::new);
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);
    public static final IntegerProperty VIGOR = IntegerProperty.create((String)"vigor", (int)0, (int)2);
    private static final float GROW_CHANCE = 0.18f;
    private static final float SPREAD_CHANCE = 0.22f;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    public SaponariaBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)VIGOR, (Comparable)Integer.valueOf(2)));
    }

    public SaponariaBlock() {
        this(SaponariaBlock.defaultProps());
    }

    private static BlockBehaviour.Properties defaultProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).sound(SoundType.GRASS).noOcclusion().randomTicks().instabreak().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        int vigor = (Integer)state.getValue((Property)VIGOR);
        if (vigor <= 0) {
            return;
        }
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 2) {
            if (rng.nextFloat() < 0.18f) {
                level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            }
            return;
        }
        if (rng.nextFloat() < 0.22f) {
            this.trySpreadOnce(level, pos, state, rng);
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.empty();
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        BlockState candidate = this.getStateForPlacement(ctx);
        if (candidate != null && candidate.getBlock() == this && (Integer)state.getValue((Property)AGE) == 0) {
            for (Direction d : Direction.values()) {
                BooleanProperty p = SaponariaBlock.getFaceProperty((Direction)d);
                if (!candidate.hasProperty((Property)p) || !state.hasProperty((Property)p) || !((Boolean)candidate.getValue((Property)p)).booleanValue() || ((Boolean)state.getValue((Property)p)).booleanValue() || !this.canAttachHere((LevelReader)ctx.getLevel(), ctx.getClickedPos(), d)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (!level.getFluidState(pos).isEmpty()) {
            return false;
        }
        BlockState here = level.getBlockState(pos);
        if (here.getBlock() != this && !here.isAir() && !SaponariaBlock.isReplaceableVegetation(here)) {
            return false;
        }
        return super.canSurvive(state, level, pos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) < 2) {
            return true;
        }
        return this.hasAnyValidSpreadTarget(level, pos);
    }

    public boolean isBonemealSuccess(Level level, RandomSource r, BlockPos pos, BlockState st) {
        return this.isValidBonemealTarget((LevelReader)level, pos, st);
    }

    public void performBonemeal(ServerLevel level, RandomSource rng, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) < 2) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), 2);
        } else {
            for (int i = 0; i < 4 && !this.trySpreadOnce(level, pos, state, rng); ++i) {
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        super.createBlockStateDefinition(b);
        b.add(new Property[]{AGE, VIGOR});
    }

    private boolean canAttachHere(LevelReader level, BlockPos pos, Direction d) {
        if (!level.getFluidState(pos).isEmpty()) {
            return false;
        }
        BlockPos supportPos = pos.relative(d);
        BlockState support = level.getBlockState(supportPos);
        return SaponariaBlock.canAttachTo((BlockGetter)level, (Direction)d, (BlockPos)pos, (BlockState)support);
    }

    private static boolean isReplaceableVegetation(BlockState state) {
        return state.is(BlockTags.REPLACEABLE);
    }

    private boolean hasAnyValidSpreadTarget(LevelReader level, BlockPos origin) {
        for (Direction dir : Direction.values()) {
            BlockState target;
            BlockPos targetPos = origin.relative(dir);
            if (!level.getFluidState(targetPos).isEmpty() || !(target = level.getBlockState(targetPos)).isAir() && !SaponariaBlock.isReplaceableVegetation(target)) continue;
            for (Direction face : Direction.values()) {
                BlockPos supportPos = targetPos.relative(face);
                BlockState support = level.getBlockState(supportPos);
                if (!SaponariaBlock.canAttachTo((BlockGetter)level, (Direction)face, (BlockPos)targetPos, (BlockState)support)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean trySpreadOnce(ServerLevel level, BlockPos pos, BlockState parent, RandomSource rng) {
        int parentVigor = (Integer)parent.getValue((Property)VIGOR);
        Direction[] order = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP};
        for (int i = 1; i < order.length - 1; ++i) {
            int j = 1 + rng.nextInt(order.length - 2);
            Direction tmp = order[i];
            order[i] = order[j];
            order[j] = tmp;
        }
        for (Direction dir : order) {
            BlockState target;
            BlockPos targetPos = pos.relative(dir);
            if (!level.getFluidState(targetPos).isEmpty() || !(target = level.getBlockState(targetPos)).isAir() && !SaponariaBlock.isReplaceableVegetation(target)) continue;
            Direction[] faces = Direction.values();
            for (int i = 0; i < faces.length; ++i) {
                int j = rng.nextInt(faces.length);
                Direction tmp = faces[i];
                faces[i] = faces[j];
                faces[j] = tmp;
            }
            for (Direction face : faces) {
                BlockPos supportPos = targetPos.relative(face);
                BlockState support = level.getBlockState(supportPos);
                if (!SaponariaBlock.canAttachTo((BlockGetter)level, (Direction)face, (BlockPos)targetPos, (BlockState)support)) continue;
                if (!target.isAir() && SaponariaBlock.isReplaceableVegetation(target)) {
                    level.destroyBlock(targetPos, false);
                }
                int childVigor = SaponariaBlock.computeChildVigor(rng, parentVigor);
                BlockState placed = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)VIGOR, (Comparable)Integer.valueOf(childVigor))).setValue((Property)SaponariaBlock.getFaceProperty((Direction)face), (Comparable)Boolean.valueOf(true));
                if (!this.canSurvive(placed, (LevelReader)level, targetPos)) continue;
                level.setBlock(targetPos, placed, 2);
                this.fillAllSupportedFaces(level, targetPos);
                return true;
            }
        }
        return false;
    }

    private void fillAllSupportedFaces(ServerLevel level, BlockPos pos) {
        BlockState current = level.getBlockState(pos);
        if (current.getBlock() != this) {
            return;
        }
        BlockState updated = current;
        for (Direction d : Direction.values()) {
            BlockPos supportPos;
            BlockState support;
            BooleanProperty p = SaponariaBlock.getFaceProperty((Direction)d);
            if (((Boolean)updated.getValue((Property)p)).booleanValue() || !level.getFluidState(pos).isEmpty() || !SaponariaBlock.canAttachTo((BlockGetter)level, (Direction)d, (BlockPos)pos, (BlockState)(support = level.getBlockState(supportPos = pos.relative(d))))) continue;
            updated = (BlockState)updated.setValue((Property)p, (Comparable)Boolean.valueOf(true));
        }
        if (updated != current && this.canSurvive(updated, (LevelReader)level, pos)) {
            level.setBlock(pos, updated, 2);
        }
    }

    private static int computeChildVigor(RandomSource rng, int parentVigor) {
        if (parentVigor <= 0) {
            return 0;
        }
        boolean decrease = rng.nextFloat() < 0.75f;
        int val = parentVigor - (decrease ? 1 : 0);
        if (val < 0) {
            val = 0;
        }
        if (val > 2) {
            val = 2;
        }
        return val;
    }
}

