/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmallPillowBlock
extends SlabBlock {
    public SmallPillowBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOL).sound(SoundType.WOOL).strength(0.2f, 1.0f));
    }

    public void updateEntityAfterFallOn(BlockGetter block, Entity player) {
        this.bounceUp(player);
        this.summonLeafParticles(player);
    }

    public void fallOn(Level p_154567_, BlockState p_154568_, BlockPos p_154569_, Entity player, float damage) {
        player.causeFallDamage(damage, 0.0f, p_154567_.damageSources().fall());
    }

    private void summonLeafParticles(Entity player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            Vec3 pos = player.position();
            int particlesCount = this.calcAmpl(player.getDeltaMovement());
            if (particlesCount != 0) {
                _level.sendParticles((ParticleOptions)((SimpleParticleType)ConcoctionModParticleTypes.FEATHER_PARTICLE.get()), pos.x, pos.y + 0.51, pos.z, particlesCount, 0.0, 0.1, 0.0, 0.4);
            }
        }
    }

    private int calcAmpl(Vec3 ampl) {
        if (ampl.y < 0.3) {
            return 0;
        }
        return (int)(Math.min((float)ampl.y, 2.0f) * 50.0f);
    }

    private void bounceUp(Entity player) {
        Vec3 vec3 = player.getDeltaMovement();
        if (vec3.y < 0.0) {
            double d0 = player instanceof LivingEntity ? 1.0 : 0.8;
            player.setDeltaMovement(vec3.x, -vec3.y * (double)0.66f * d0, vec3.z);
        }
    }

    public void stepOn(Level p_154573_, BlockPos p_154574_, BlockState p_154575_, Entity p_154576_) {
    }

    public boolean useShapeForLightOcclusion(BlockState p_56395_) {
        return p_56395_.getValue((Property)TYPE) != SlabType.DOUBLE;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56388_) {
        p_56388_.add(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState p_56390_, BlockGetter p_56391_, BlockPos p_56392_, CollisionContext p_56393_) {
        SlabType slabtype = (SlabType)p_56390_.getValue((Property)TYPE);
        switch (slabtype) {
            case DOUBLE: {
                return Shapes.block();
            }
            case TOP: {
                return TOP_AABB;
            }
        }
        return BOTTOM_AABB;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 125;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 50;
    }
}

