/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathType;

public class SoapBlockBlock
extends Block {
    public SoapBlockBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).sound(SoundType.STONE).strength(1.5f, 2.0f).requiresCorrectToolForDrops().friction(1.0f));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.STICKY_HONEY;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        super.stepOn(level, pos, state, entity);
        if (!level.isClientSide) {
            return;
        }
        if (!entity.onGround()) {
            return;
        }
        double dx = entity.getX() - entity.xOld;
        double dz = entity.getZ() - entity.zOld;
        double speed = Math.sqrt(dx * dx + dz * dz);
        double minSpeed = 0.05;
        if (speed < 0.05) {
            return;
        }
        if ((level.getGameTime() + (long)entity.getId() & 3L) != 0L) {
            return;
        }
        double maxRefSpeed = 0.2;
        double t = Mth.clamp((double)((speed - 0.05) / 0.15000000000000002), (double)0.0, (double)1.0);
        float spawnProb = (float)(0.1 + 0.25 * t);
        if (level.random.nextFloat() > spawnProb) {
            return;
        }
        int count = level.random.nextFloat() < 0.15f ? 2 : 1;
        for (int i = 0; i < count; ++i) {
            double ox = 0.3 + level.random.nextDouble() * 0.4;
            double oz = 0.3 + level.random.nextDouble() * 0.4;
            double x = (double)pos.getX() + ox;
            double y = (double)pos.getY() + 1.02;
            double z = (double)pos.getZ() + oz;
            double vx = level.random.nextGaussian() * 0.008;
            double vz = level.random.nextGaussian() * 0.008;
            double vy = 0.02 + 0.03 * t + level.random.nextDouble() * 0.015;
            level.addParticle((ParticleOptions)ConcoctionModParticleTypes.SOAP_BUBBLE.get(), x, y, z, vx, vy, vz);
        }
        if ((level.getGameTime() + (long)entity.getId() & 7L) == 0L && level.random.nextFloat() < 0.2f) {
            double sx = (double)pos.getX() + 0.4 + level.random.nextDouble() * 0.2;
            double sy = (double)pos.getY() + 1.1;
            double sz = (double)pos.getZ() + 0.4 + level.random.nextDouble() * 0.2;
            float volume = 0.25f + level.random.nextFloat() * 0.15f;
            float pitch = 0.9f + level.random.nextFloat() * 0.3f;
            level.playLocalSound(sx, sy, sz, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, volume, pitch, false);
        }
    }
}

