/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.init.ConcoctionModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SoapLayerBlock
extends Block {
    private static final VoxelShape LAYER_SHAPE = SoapLayerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public SoapLayerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).sound(SoundType.SLIME_BLOCK).instabreak().noOcclusion().noCollission().friction(1.079f).pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return LAYER_SHAPE;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ConcoctionModItems.SOAP.get());
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.STICKY_HONEY;
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return 1.079f;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide) {
            return;
        }
        if (!entity.onGround()) {
            return;
        }
        double dx = entity.getX() - entity.xOld;
        double dz = entity.getZ() - entity.zOld;
        double speed = Math.sqrt(dx * dx + dz * dz);
        double minSpeed = 0.04;
        if (speed < 0.04) {
            return;
        }
        if ((level.getGameTime() + (long)entity.getId() & 3L) != 0L) {
            return;
        }
        double maxRefSpeed = 0.2;
        double t = Mth.clamp((double)((speed - 0.04) / 0.16), (double)0.0, (double)1.0);
        float spawnProb = (float)(0.12 + 0.3 * t);
        if (level.random.nextFloat() > spawnProb) {
            return;
        }
        int minParticles = 1;
        int maxParticles = 2;
        int count = Mth.clamp((int)((int)Math.round(1.0 + t * 0.6)), (int)minParticles, (int)maxParticles);
        for (int i = 0; i < count; ++i) {
            double baseY = (double)pos.getY() + 0.0625 + 0.08;
            double ox = 0.2 + level.random.nextDouble() * 0.6 + level.random.nextGaussian() * 0.04;
            double oz = 0.2 + level.random.nextDouble() * 0.6 + level.random.nextGaussian() * 0.04;
            ox = Mth.clamp((double)ox, (double)0.1, (double)0.9);
            oz = Mth.clamp((double)oz, (double)0.1, (double)0.9);
            double x = (double)pos.getX() + ox;
            double y = baseY;
            double z = (double)pos.getZ() + oz;
            double horizJitter = 0.006 + t * 0.006;
            double vx = level.random.nextGaussian() * horizJitter;
            double vz = level.random.nextGaussian() * horizJitter;
            double vy = 0.02 + 0.04 * t + level.random.nextDouble() * 0.02;
            level.addParticle((ParticleOptions)ConcoctionModParticleTypes.SOAP_BUBBLE.get(), x, y, z, vx, vy, vz);
        }
        if ((level.getGameTime() + (long)entity.getId() & 7L) == 0L) {
            float popProb = (float)(0.08 + 0.2 * t);
            if (level.random.nextFloat() < popProb) {
                double sx = (double)pos.getX() + 0.3 + level.random.nextDouble() * 0.4;
                double sy = (double)pos.getY() + 0.0625 + 0.1;
                double sz = (double)pos.getZ() + 0.3 + level.random.nextDouble() * 0.4;
                float volume = 0.25f + level.random.nextFloat() * 0.15f;
                float pitch = 0.9f + level.random.nextFloat() * 0.3f;
                level.playLocalSound(sx, sy, sz, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, volume, pitch, false);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        return level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = this.defaultBlockState();
        return this.canSurvive(state, (LevelReader)ctx.getLevel(), ctx.getClickedPos()) ? state : null;
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (dir == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, dir, neighborState, level, pos, neighborPos);
    }
}

