/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class SoulIceBlock
extends Block {
    public SoulIceBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).sound(SoundType.GLASS).strength(0.5f, 10.0f).lightLevel(s -> 3).requiresCorrectToolForDrops().friction(0.9f).pushReaction(PushReaction.DESTROY).hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        ResourceKey resourceKey;
        super.onPlace(blockstate, world, pos, oldState, moving);
        if (world instanceof Level) {
            Level _lvl = world;
            resourceKey = _lvl.dimension();
        } else if (world instanceof WorldGenLevel) {
            WorldGenLevel _wgl = (WorldGenLevel)world;
            resourceKey = _wgl.getLevel().dimension();
        } else {
            resourceKey = Level.OVERWORLD;
        }
        if (resourceKey == Level.NETHER) {
            world.setBlock(BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), ((Block)ConcoctionModBlocks.WEIGHTED_SOULS.get()).defaultBlockState(), 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        this.doParticles(world, pos.getX(), pos.getY(), pos.getZ());
        return retval;
    }

    public void wasExploded(Level world, BlockPos pos, Explosion e) {
        super.wasExploded(world, pos, e);
        this.doParticles(world, pos.getX(), pos.getY(), pos.getZ());
    }

    private void doParticles(Level level, double x, double y, double z) {
        if (!level.isClientSide()) {
            level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.BLOCKS, 1.0f, (float)Math.random());
        } else {
            level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.BLOCKS, 1.0f, (float)Math.random(), false);
        }
        level.addParticle((ParticleOptions)ParticleTypes.SOUL, x + 0.5, y + 0.5, z + 0.5, 0.0, 0.1, 0.0);
    }
}

