/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mcreator.concoction.ConcoctionMod;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import oshi.util.tuples.Pair;

public class SunflowerBlock
extends CropBlock {
    public static final EnumProperty<FacingProperty> FACING = EnumProperty.create((String)"facing", FacingProperty.class);
    public static final int FIRST_STAGE_MAX_AGE = 2;
    public static final int SECOND_STAGE_MAX_AGE = 3;
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)5);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public SunflowerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).sound(SoundType.GRASS).strength(0.0f, 10.0f).noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue(FACING, (Comparable)((Object)FacingProperty.EAST))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[this.getAge(pState)];
    }

    public boolean isRandomlyTicking(BlockState p_52288_) {
        return true;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource random) {
        float f;
        int nextAge;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        this.rotate((LevelAccessor)pLevel, pPos, pState);
        if (pLevel.getRawBrightness(pPos, 0) >= 9 && pState.getValue(HALF) == DoubleBlockHalf.LOWER && (nextAge = this.getAge(pState) + 1) <= this.getMaxAge() && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (random.nextInt((int)(25.0f / (f = SunflowerBlock.getGrowthSpeed((BlockState)pState, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (nextAge < 2) {
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
            } else if (nextAge >= 2 && (pLevel.getBlockState(pPos.above(1)).is(Blocks.AIR) || pLevel.getBlockState(pPos.above(1)).is((Block)this))) {
                pLevel.setBlock(pPos.above(1), this.getState(pState, nextAge, DoubleBlockHalf.UPPER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
            }
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public FacingProperty getRotateFacing(LevelAccessor world, BlockState pState) {
        int dayTime = Math.floorMod(world.dayTime(), 24000);
        if (dayTime >= 0 && dayTime < 3000) {
            return FacingProperty.EAST;
        }
        if (dayTime >= 3000 && dayTime < 6000) {
            return FacingProperty.EASTISH;
        }
        if (dayTime >= 6000 && dayTime < 9000) {
            return FacingProperty.WESTISH;
        }
        if (dayTime >= 9000) {
            return FacingProperty.WEST;
        }
        return (FacingProperty)((Object)pState.getValue(FACING));
    }

    public void rotate(LevelAccessor world, BlockPos pPos, BlockState pState) {
        if (world.canSeeSkyFromBelowWater(pPos.above(3)) && world instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)world;
            if (pState.getValue(HALF) == DoubleBlockHalf.LOWER && !sLevel.isRainingAt(pPos)) {
                FacingProperty toRotate = this.getRotateFacing(world, pState);
                BlockPos.betweenClosedStream((BlockPos)pPos.offset(-2, -2, -2), (BlockPos)pPos.offset(2, 2, 2)).map(pos -> new Pair(pos, (Object)world.getBlockState(pos))).filter(p -> ((BlockState)p.getB()).is((Block)this) && ((DoubleBlockHalf)((BlockState)p.getB()).getValue(HALF)).equals((Object)DoubleBlockHalf.LOWER) && !((FacingProperty)((Object)((Object)((BlockState)p.getB()).getValue(FACING)))).equals((Object)toRotate)).forEach(pNeighbor -> {
                    world.setBlock((BlockPos)pNeighbor.getA(), (BlockState)((BlockState)pNeighbor.getB()).setValue(FACING, (Comparable)((Object)toRotate)), 3);
                    if (world.getBlockState(((BlockPos)pNeighbor.getA()).above(1)).is((Block)this) && ((DoubleBlockHalf)world.getBlockState(((BlockPos)pNeighbor.getA()).above(1)).getValue(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
                        world.setBlock(((BlockPos)pNeighbor.getA()).above(1), this.getState((BlockState)pNeighbor.getB(), (Integer)((BlockState)pNeighbor.getB()).getValue((Property)AGE), DoubleBlockHalf.UPPER, toRotate), 3);
                    }
                });
            }
        }
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockPos lowerPos;
        BlockState lowerState;
        DoubleBlockHalf currentHalf;
        int maxAge;
        int nextAge = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (nextAge > (maxAge = this.getMaxAge())) {
            nextAge = maxAge;
        }
        if ((currentHalf = (DoubleBlockHalf)pState.getValue(HALF)) == DoubleBlockHalf.LOWER) {
            if (nextAge < 2) {
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
            } else if (nextAge >= 2 && (pLevel.getBlockState(pPos.above(1)).is(Blocks.AIR) || pLevel.getBlockState(pPos.above(1)).is((Block)this))) {
                pLevel.setBlock(pPos.above(1), this.getState(pState, nextAge, DoubleBlockHalf.UPPER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.LOWER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
            }
        } else if (currentHalf == DoubleBlockHalf.UPPER && (lowerState = pLevel.getBlockState(lowerPos = pPos.below())).is((Block)this)) {
            if (nextAge < 2) {
                pLevel.setBlock(lowerPos, this.getState(lowerState, nextAge, DoubleBlockHalf.LOWER, (FacingProperty)((Object)lowerState.getValue(FACING))), 2);
            } else if (nextAge >= 2) {
                pLevel.setBlock(pPos, this.getState(pState, nextAge, DoubleBlockHalf.UPPER, (FacingProperty)((Object)lowerState.getValue(FACING))), 2);
                pLevel.setBlock(lowerPos, this.getState(lowerState, nextAge, DoubleBlockHalf.LOWER, (FacingProperty)((Object)lowerState.getValue(FACING))), 2);
            }
        }
    }

    public BlockState getState(BlockState pState, int age, DoubleBlockHalf half, FacingProperty facing) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age))).setValue(HALF, (Comparable)half)).setValue(FACING, (Comparable)((Object)facing));
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return ((Integer)pState.getValue((Property)AGE)).intValue() != this.getMaxAge();
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if ((Integer)pState.getValue((Property)AGE) >= 2) {
                return super.canSurvive(pState, pLevel, pPos) && pLevel.getBlockState(pPos.above(1)).is((Block)this);
            }
            return super.canSurvive(pState, pLevel, pPos);
        }
        return super.canSurvive(pState, pLevel, pPos) || pLevel.getBlockState(pPos.below(1)).is((Block)this) && (Integer)pLevel.getBlockState(pPos.below(1)).getValue((Property)AGE) >= 2 && pLevel.getBlockState(pPos.below(1)).getValue(HALF) != pState.getValue(HALF);
    }

    public boolean mayPlaceOn(BlockState pState, BlockGetter p_52303_, BlockPos p_52304_) {
        return (pState.is(BlockTags.DIRT) || pState.getBlock() instanceof FarmBlock) && !(pState.getBlock() instanceof SunflowerBlock);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player player) {
        if (!pLevel.isClientSide) {
            if (player.isCreative()) {
                SunflowerBlock.breakBlock(false, pLevel, pPos, pState, player);
            } else {
                SunflowerBlock.breakBlock(true, pLevel, pPos, pState, player);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, player);
    }

    public void playerDestroy(Level p_52865_, Player p_52866_, BlockPos p_52867_, BlockState p_52868_, @Nullable BlockEntity p_52869_, ItemStack p_52870_) {
        super.playerDestroy(p_52865_, p_52866_, p_52867_, Blocks.AIR.defaultBlockState(), p_52869_, p_52870_);
    }

    protected static void breakBlock(boolean dropItems, Level pLevel, BlockPos pPos, BlockState pState, Player player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            BlockPos blockpos = pPos.below();
            BlockState blockstate = pLevel.getBlockState(blockpos);
            if (blockstate.is(pState.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
                BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                pLevel.setBlock(blockpos, blockstate1, 35);
                pLevel.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
                if (dropItems) {
                    SunflowerBlock.dropResources((BlockState)blockstate, (Level)pLevel, (BlockPos)blockpos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                }
            }
        } else if (dropItems) {
            SunflowerBlock.dropResources((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, FACING, HALF});
    }

    protected void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block p_60512_, BlockPos neighbor, boolean p_60514_) {
        BlockState neighborState = pLevel.getBlockState(neighbor);
        if (!pLevel.isClientSide() && pState.is((Block)this) && pState.getValue(HALF) == DoubleBlockHalf.LOWER && neighborState.is((Block)this) && !((FacingProperty)((Object)pState.getValue(FACING))).equals(neighborState.getValue(FACING)) && pState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            ConcoctionMod.queueServerWork(RandomSource.create().nextInt(40) + 20, () -> this.rotate((LevelAccessor)pLevel, pPos, pState));
        }
        super.neighborChanged(pState, pLevel, pPos, p_60512_, neighbor, p_60514_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FacingProperty toRotate = this.getRotateFacing((LevelAccessor)context.getLevel(), this.defaultBlockState());
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue(FACING, (Comparable)((Object)toRotate))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    public int getMaxAge() {
        return 5;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.SUNFLOWER_SEEDS.get();
    }

    protected ItemInteractionResult useItemOn(ItemStack pItem, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand p_316595_, BlockHitResult p_316140_) {
        if (!pPlayer.isShiftKeyDown() && (Integer)pState.getValue((Property)AGE) == 5 && pState.getValue(HALF) == DoubleBlockHalf.UPPER) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)pLevel;
                pLevel.setBlock(pPos.below(1), this.getState(pState, 3, DoubleBlockHalf.LOWER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
                pLevel.setBlock(pPos, this.getState(pState, 3, DoubleBlockHalf.UPPER, (FacingProperty)((Object)pState.getValue(FACING))), 2);
                if (!_level.isClientSide()) {
                    _level.playSound(null, pPos, Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.cave_vines.pick_berries"))), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(pPos, Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.cave_vines.pick_berries"))), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
                ItemEntity entityToSpawn = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.SUNFLOWER_SEEDS.get(), 2));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
                if (Math.random() < 0.5) {
                    ItemEntity AdditEntityToSpawn = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.SUNFLOWER_SEEDS.get()));
                    AdditEntityToSpawn.setPickUpDelay(10);
                    _level.addFreshEntity((Entity)AdditEntityToSpawn);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pItem, pState, pLevel, pPos, pPlayer, p_316595_, p_316140_);
    }

    public static enum FacingProperty implements StringRepresentable
    {
        EAST("east"),
        EASTISH("eastish"),
        WESTISH("westish"),
        WEST("west");

        private final String name;

        private FacingProperty(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

