/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WeightedSoulsBlock
extends LiquidBlock {
    public WeightedSoulsBlock() {
        super((FlowingFluid)ConcoctionModFluids.WEIGHTED_SOULS.get(), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).strength(100.0f).hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).lightLevel(s -> 6).noCollission().noLootTable().liquid().pushReaction(PushReaction.DESTROY).sound(SoundType.EMPTY).replaceable());
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        ResourceKey resourceKey;
        super.onPlace(blockstate, world, pos, oldState, moving);
        if (world instanceof Level) {
            Level level = world;
            resourceKey = level.dimension();
        } else if (world instanceof WorldGenLevel) {
            WorldGenLevel wgl = (WorldGenLevel)world;
            resourceKey = wgl.getLevel().dimension();
        } else {
            resourceKey = Level.OVERWORLD;
        }
        if (resourceKey != Level.NETHER) {
            world.setBlock(BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), ((Block)ConcoctionModBlocks.SOUL_ICE.get()).defaultBlockState(), 3);
        }
    }

    public boolean isPathfindable(BlockState p_53267_, PathComputationType p_53270_) {
        return false;
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        if (entity == null) {
            return;
        }
        if (!world.isClientSide()) {
            if (!entity.isInLava()) {
                entity.setTicksFrozen(300);
            }
            entity.clearFire();
            entity.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"concoction:soul_damage")))), 2.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        if (world.isEmptyBlock(BlockPos.containing((double)x, (double)(y + 1.0), (double)z)) && Math.random() < 0.015) {
            world.addParticle((ParticleOptions)ParticleTypes.SOUL, x + 0.5, y + 0.9, z + 0.5, 0.0, Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.45), 0.0);
            if (world instanceof Level) {
                Level _level = world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.BLOCKS, 1.0f, (float)Math.random());
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.BLOCKS, 1.0f, (float)Math.random(), false);
                }
            }
            if (Math.random() < 0.5) {
                world.addParticle((ParticleOptions)ParticleTypes.SOUL, x + 0.5, y + 0.9, z + 0.5, Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.45), Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1));
            }
            if (Math.random() < 0.5) {
                world.addParticle((ParticleOptions)ParticleTypes.SOUL, x + 0.5, y + 0.9, z + 0.5, Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.45), Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1));
            }
            if (Math.random() < 0.8) {
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x + 0.5, y + 0.9, z + 0.5, Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.45), Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1));
            }
        }
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, neighborPos, isMoving);
        BlockPos blockAbove = pos.above();
        if (world.getBlockState(blockAbove).getBlock() == Blocks.LAVA) {
            world.setBlock(pos, Blocks.BLACKSTONE.defaultBlockState(), 3);
            world.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.7f, 1.0f);
        }
    }
}

