/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block.entity;

import com.google.gson.Gson;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mcreator.concoction.block.OvenBlock;
import net.mcreator.concoction.init.ConcoctionModBlockEntities;
import net.mcreator.concoction.init.ConcoctionModRecipes;
import net.mcreator.concoction.recipe.oven.OvenRecipe;
import net.mcreator.concoction.recipe.oven.OvenRecipeInput;
import net.mcreator.concoction.world.inventory.OvenGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends RandomizableContainerBlockEntity {
    private final int ContainerSize = 9;
    private boolean isCooking = false;
    private RecipeHolder<OvenRecipe> recipe = null;
    private Map<String, String> craftResult = Map.ofEntries(Map.entry("id", ""), Map.entry("count", ""), Map.entry("interactionType", ""));
    private int progress = 0;
    private int maxProgress = 200;
    private final int DEFAULT_MAX_PROGRESS = 200;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.ContainerSize, (Object)ItemStack.EMPTY);
    private static final int SLOT_BOTTLE = 0;
    private static final int SLOT_FIRST_CRAFT = 1;
    private static final int SLOT_LAST_CRAFT = 6;
    private static final int SLOT_BOWL = 7;
    private static final int SLOT_OUTPUT = 8;

    public OvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ConcoctionModBlockEntities.OVEN_BLOCK.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress = tag.getInt("cooking.progress");
        this.maxProgress = tag.getInt("cooking.max_progress");
        this.isCooking = tag.getBoolean("cooking.is_cooking");
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.craftResult = (Map)new Gson().fromJson(tag.getString("cooking.craft_result"), HashMap.class);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("cooking.progress", this.progress);
        tag.putInt("cooking.max_progress", this.maxProgress);
        tag.putBoolean("cooking.is_cooking", this.isCooking);
        tag.putString("cooking.craft_result", new Gson().toJson(this.craftResult));
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        boolean shouldBeLit;
        if (level.isClientSide) {
            return;
        }
        boolean wasLit = (Boolean)pState.getValue((Property)OvenBlock.LIT);
        if (wasLit != (shouldBeLit = this.isHeated(level, pPos))) {
            level.setBlock(pPos, (BlockState)pState.setValue((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
        }
        if (!shouldBeLit) {
            if (this.isCooking) {
                this.resetProgressOnly();
            }
            return;
        }
        Optional<RecipeHolder<OvenRecipe>> currentRecipe = this.getCurrentRecipe();
        if (currentRecipe.isPresent()) {
            if (!this.isCooking) {
                this.recipe = currentRecipe.get();
                this.isCooking = true;
                this.maxProgress = ((OvenRecipe)this.recipe.value()).getCookingTime();
                this.setChanged();
            } else if (!this.isSameRecipe(currentRecipe.get(), this.recipe)) {
                this.resetProgress();
                this.recipe = currentRecipe.get();
                this.isCooking = true;
                this.maxProgress = ((OvenRecipe)this.recipe.value()).getCookingTime();
                this.setChanged();
                return;
            }
            if (this.canAddResult()) {
                this.increaseCraftingProgress();
                if (this.hasCraftingFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
            }
        } else if (this.isCooking) {
            this.resetProgress();
        }
    }

    private boolean isSameRecipe(RecipeHolder<OvenRecipe> recipe1, RecipeHolder<OvenRecipe> recipe2) {
        if (recipe1 == null || recipe2 == null) {
            return false;
        }
        if (recipe1.id().equals((Object)recipe2.id())) {
            return true;
        }
        NonNullList ingredients1 = ((OvenRecipe)recipe1.value()).getIngredients();
        NonNullList ingredients2 = ((OvenRecipe)recipe2.value()).getIngredients();
        if (ingredients1.size() != ingredients2.size()) {
            return false;
        }
        ArrayList sorted1 = new ArrayList(ingredients1);
        ArrayList sorted2 = new ArrayList(ingredients2);
        sorted1.sort((a, b) -> a.toString().compareTo(b.toString()));
        sorted2.sort((a, b) -> a.toString().compareTo(b.toString()));
        for (int i = 0; i < sorted1.size(); ++i) {
            if (((Ingredient)sorted1.get(i)).toString().equals(((Ingredient)sorted2.get(i)).toString())) continue;
            return false;
        }
        return true;
    }

    private boolean isHeated(Level level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        Block belowBlock = belowState.getBlock();
        if (belowBlock instanceof CampfireBlock) {
            return (Boolean)belowState.getValue((Property)CampfireBlock.LIT);
        }
        if (belowBlock instanceof FireBlock || belowBlock instanceof MagmaBlock) {
            return true;
        }
        return belowBlock == Blocks.LAVA;
    }

    private boolean canAddResult() {
        if (this.recipe == null) {
            return false;
        }
        ItemStack resultSlot = (ItemStack)this.items.get(8);
        Map<String, String> recipeResult = ((OvenRecipe)this.recipe.value()).getResult();
        if (resultSlot.isEmpty()) {
            return true;
        }
        ResourceLocation resultId = ResourceLocation.parse((String)recipeResult.get("id"));
        if (!((Item)BuiltInRegistries.ITEM.get(resultId)).equals(resultSlot.getItem())) {
            return false;
        }
        int resultCount = this.parseResultCount(recipeResult);
        return resultSlot.getCount() + resultCount <= resultSlot.getMaxStackSize();
    }

    private int parseResultCount(Map<String, String> recipeResult) {
        try {
            return Math.max(1, Integer.parseInt(recipeResult.getOrDefault("count", "1").trim()));
        }
        catch (Exception e) {
            return 1;
        }
    }

    private int bowlsToConsumePerCraft(RecipeHolder<OvenRecipe> rh) {
        if (rh == null) {
            return 0;
        }
        if (((OvenRecipe)rh.value()).getBowlIngredient() == null || ((OvenRecipe)rh.value()).getBowlIngredient().isEmpty()) {
            return 0;
        }
        return this.parseResultCount(((OvenRecipe)rh.value()).getResult());
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = this.recipe == null ? 200 : ((OvenRecipe)this.recipe.value()).getCookingTime();
        this.isCooking = false;
        this.recipe = null;
        this.craftResult = Map.of("id", "", "count", "", "interactionType", "");
        this.setChanged();
    }

    private void resetProgressOnly() {
        this.progress = 0;
        this.isCooking = false;
        this.setChanged();
    }

    private void craftItem() {
        if (this.recipe == null) {
            return;
        }
        Map<String, String> recipeResult = ((OvenRecipe)this.recipe.value()).getResult();
        ResourceLocation resultId = ResourceLocation.parse((String)recipeResult.get("id"));
        int resultCount = this.parseResultCount(recipeResult);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(resultId), resultCount);
        ItemStack resultSlot = (ItemStack)this.items.get(8);
        if (resultSlot.isEmpty()) {
            this.items.set(8, (Object)result);
        } else {
            resultSlot.grow(resultCount);
        }
        this.consumeIngredients(this.recipe);
        this.setChanged();
    }

    private void consumeIngredients(RecipeHolder<OvenRecipe> rh) {
        if (rh == null || this.level == null) {
            return;
        }
        int bowlsPerCraft = this.bowlsToConsumePerCraft(rh);
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (int i = 0; i <= 7; ++i) {
            int toRemove;
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.isEmpty()) continue;
            int shrinkAmount = 1;
            if (i == 7 && bowlsPerCraft > 0) {
                shrinkAmount = bowlsPerCraft;
            }
            if ((toRemove = Math.min(stack.getCount(), shrinkAmount)) <= 0) continue;
            if (stack.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"bottles")))) {
                drop = new ItemStack((ItemLike)Items.GLASS_BOTTLE, toRemove);
                containers.add(drop);
            } else if (stack.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"buckets")))) {
                drop = new ItemStack((ItemLike)Items.BUCKET, toRemove);
                containers.add(drop);
            } else if (stack.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"bowls")))) {
                drop = new ItemStack((ItemLike)Items.BOWL, toRemove);
                containers.add(drop);
            }
            stack.shrink(toRemove);
            if (!stack.isEmpty()) continue;
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
        for (ItemStack container : containers) {
            if (this.level == null || this.level.isClientSide || container.isEmpty()) continue;
            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, container);
            itemEntity.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)itemEntity);
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
        this.setChanged();
    }

    private Optional<RecipeHolder<OvenRecipe>> getCurrentRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ConcoctionModRecipes.OVEN_RECIPE_TYPE.get(), (RecipeInput)new OvenRecipeInput(this.getItems()), this.level);
    }

    public int getContainerSize() {
        return this.ContainerSize;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItem(int slot, ItemStack stack) {
        boolean isIngredientSlot;
        ItemStack previousStack = (ItemStack)this.items.get(slot);
        boolean isSlotEmpty = previousStack.isEmpty();
        boolean isStackEmpty = stack.isEmpty();
        boolean isDifferentItem = !isSlotEmpty && !isStackEmpty && !ItemStack.matches((ItemStack)previousStack, (ItemStack)stack);
        boolean bl = isIngredientSlot = slot >= 0 && slot < 8;
        if (isIngredientSlot && (isDifferentItem || isSlotEmpty != isStackEmpty)) {
            ItemStack oldStack = (ItemStack)this.items.get(slot);
            ItemStack testStack = oldStack.copy();
            if (!testStack.isEmpty()) {
                testStack.setCount(1);
            }
            this.items.set(slot, (Object)testStack);
            Optional<RecipeHolder<OvenRecipe>> originalRecipe = this.getCurrentRecipe();
            this.items.set(slot, (Object)stack);
            Optional<RecipeHolder<OvenRecipe>> newRecipe = this.getCurrentRecipe();
            boolean shouldReset = false;
            if (this.isCooking && this.recipe != null) {
                if (originalRecipe.isPresent() && this.isSameRecipe(originalRecipe.get(), this.recipe)) {
                    shouldReset = false;
                } else if (newRecipe.isPresent()) {
                    if (!this.isSameRecipe(newRecipe.get(), this.recipe)) {
                        shouldReset = true;
                    }
                } else {
                    shouldReset = true;
                }
            }
            this.items.set(slot, (Object)oldStack);
            if (shouldReset) {
                this.resetProgressOnly();
            }
        }
        stack.limitSize(this.getMaxStackSize(stack));
        this.items.set(slot, (Object)stack);
        this.setChanged();
    }

    protected void setItems(NonNullList<ItemStack> Items2) {
        this.items = Items2;
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        tag.putInt("Progress", this.progress);
        tag.putInt("MaxProgress", this.maxProgress);
        tag.putBoolean("IsCooking", this.isCooking);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        this.handleUpdateTag(tag, registries);
        this.progress = tag.getInt("Progress");
        this.maxProgress = tag.getInt("MaxProgress");
        this.isCooking = tag.getBoolean("IsCooking");
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        this.loadAdditional(tag, registries);
        this.progress = tag.getInt("Progress");
        this.maxProgress = tag.getInt("MaxProgress");
        this.isCooking = tag.getBoolean("IsCooking");
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.oven");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new OvenGUIMenu(pContainerId, pPlayerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory) {
        return this.createMenu(pContainerId, pPlayerInventory, null);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public boolean isCooking() {
        return this.isCooking;
    }

    public boolean isLit() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)OvenBlock.LIT)) {
            return (Boolean)state.getValue((Property)OvenBlock.LIT);
        }
        return false;
    }
}

