/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FeatherParticleParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private float angularVelocity;
    private float angularAcceleration;

    public static FeatherParticleParticleProvider provider(SpriteSet spriteSet) {
        return new FeatherParticleParticleProvider(spriteSet);
    }

    protected FeatherParticleParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.6f, 0.6f);
        this.lifetime = Math.max(1, 40 + (this.random.nextInt(10) - 5));
        this.gravity = 0.05f;
        this.hasPhysics = true;
        this.xd = vx * 0.6;
        this.yd = vy * 0.6;
        this.zd = vz * 0.6;
        this.angularVelocity = 0.2f;
        this.angularAcceleration = -0.01f;
        this.pickSprite(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += this.angularVelocity;
        this.angularVelocity += this.angularAcceleration;
        ClientLevel world = this.level;
        boolean condition = false;
        condition = false;
        if (world.getBlockState(BlockPos.containing((double)this.x, (double)(this.y - 0.05), (double)this.z)).canOcclude()) {
            condition = true;
        }
        if (condition) {
            this.remove();
        }
    }

    public static class FeatherParticleParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FeatherParticleParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FeatherParticleParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

