/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.compat;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mcreator.concoction.recipe.cauldron.CauldronBrewingRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CauldronRecipeCategory
implements IRecipeCategory<CauldronBrewingRecipe> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"textures/gui/hud/boiling_cauldron_gui.png");
    public static final RecipeType<CauldronBrewingRecipe> CAULDRON_RECIPE_TYPE = RecipeType.create((String)"concoction", (String)"cauldron_brewing", CauldronBrewingRecipe.class);
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;
    protected final IDrawableAnimated arrow;

    public CauldronRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 134, 78);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.CAULDRON));
        this.arrow = helper.drawableBuilder(TEXTURE, 134, 0, 44, 24).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CauldronBrewingRecipe> getRecipeType() {
        return CAULDRON_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.cooking_cauldron.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CauldronBrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 50, 27);
    }

    public static boolean isCursorInsideBounds(int iconX, int iconY, int iconWidth, int iconHeight, double cursorX, double cursorY) {
        return (double)iconX <= cursorX && cursorX < (double)(iconX + iconWidth) && (double)iconY <= cursorY && cursorY < (double)(iconY + iconHeight);
    }

    public void getTooltip(ITooltipBuilder tooltip, CauldronBrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int cookTimeSeconds;
        if (CauldronRecipeCategory.isCursorInsideBounds(44, 20, 44, 23, mouseX, mouseY) && (cookTimeSeconds = recipe.getCookingTime() / 20) > 0) {
            tooltip.add((FormattedText)Component.translatable((String)"gui.cooking_cauldron.time.seconds", (Object[])new Object[]{cookTimeSeconds}));
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CauldronBrewingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 20).addIngredients(recipe.getIngredient(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 29, 20).addIngredients(recipe.getIngredient(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 38).addIngredients(recipe.getIngredient(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 29, 38).addIngredients(recipe.getIngredient(3));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 31).addItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)recipe.getOutput().get("id"))), Integer.parseInt(recipe.getOutput().get("count"))));
        ItemStack catalyst = switch (recipe.getOutput().get("interactionType")) {
            case "hand" -> ItemStack.EMPTY;
            case "bucket" -> new ItemStack((ItemLike)Items.BUCKET);
            case "bottle" -> new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            case "bowl" -> new ItemStack((ItemLike)Items.BOWL);
            default -> ItemStack.EMPTY;
        };
        builder.addSlot(RecipeIngredientRole.CATALYST, 63, 8).addItemStack(catalyst);
    }
}

