/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.custom;

import java.util.Optional;
import net.mcreator.concoction.entity.SunstruckEntity;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModEntities;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CustomAttackSunflowerGoal
extends Goal {
    private final Zombie zombie;
    private Optional<BlockPos> target;
    private int transformCounter = 0;

    public CustomAttackSunflowerGoal(Zombie zombie) {
        this.zombie = zombie;
    }

    public boolean canUse() {
        Level level = this.zombie.level();
        if (level.isClientSide()) {
            return false;
        }
        this.target = BlockPos.findClosestMatch((BlockPos)this.zombie.blockPosition(), (int)8, (int)8, blockPos -> level.getBlockState(blockPos).is(ConcoctionModBlocks.SUNFLOWER));
        if (this.target.isPresent()) {
            if (this.zombie.getType().equals(EntityType.ZOMBIE)) {
                this.zombie.targetSelector.removeAllGoals(goal -> true);
                this.zombie.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this.zombie, Player.class, true));
                this.zombie.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this.zombie, Villager.class, false));
                this.zombie.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this.zombie, WanderingTrader.class, false));
            }
            return true;
        }
        return false;
    }

    public void tick() {
        Level level = this.zombie.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.target.ifPresent(targetBlockPos -> {
            if (this.zombie.getType().equals(EntityType.ZOMBIE)) {
                this.zombie.getNavigation().moveTo((double)targetBlockPos.getX(), (double)targetBlockPos.getY(), (double)targetBlockPos.getZ(), 1.0);
                this.zombie.getLookControl().setLookAt((double)targetBlockPos.getX(), (double)(targetBlockPos.getY() + 1), (double)targetBlockPos.getZ());
                if (this.zombie.blockPosition().distToCenterSqr((double)targetBlockPos.getX(), (double)targetBlockPos.getY(), (double)targetBlockPos.getZ()) < 3.0) {
                    if (this.transformCounter % 20 == 0) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.zombie.getX(), this.zombie.getY() + 1.0, this.zombie.getZ(), 4, 0.3, 0.3, 0.3, 0.1);
                    }
                    if (this.transformCounter > 100) {
                        SunstruckEntity sunstruckEntity;
                        EntityType type = (EntityType)ConcoctionModEntities.SUNSTRUCK.get();
                        Entity sunstruck = type.create(this.zombie.level());
                        assert (sunstruck != null);
                        sunstruck.moveTo(this.zombie.getX(), this.zombie.getY(), this.zombie.getZ(), this.zombie.getYRot(), this.zombie.getXRot());
                        BlockPos zombiePos = this.zombie.blockPosition();
                        serverLevel.getPlayers(player -> player.distanceToSqr((double)zombiePos.getX(), (double)zombiePos.getY(), (double)zombiePos.getZ()) <= 64.0).forEach(player -> Utils.addAchievement(player, "concoction:sunstruck_transformed"));
                        if (this.zombie.isBaby() && sunstruck instanceof SunstruckEntity) {
                            sunstruckEntity = (SunstruckEntity)sunstruck;
                            sunstruckEntity.setBaby(true);
                        }
                        if (sunstruck instanceof SunstruckEntity) {
                            sunstruckEntity = (SunstruckEntity)sunstruck;
                            sunstruckEntity.setItemInHand(this.zombie.getUsedItemHand(), this.zombie.getItemInHand(this.zombie.getUsedItemHand()).copy());
                            sunstruckEntity.setItemInHand(this.zombie.getUsedItemHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, this.zombie.getItemInHand(this.zombie.getUsedItemHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).copy());
                            for (EquipmentSlot slot : EquipmentSlot.values()) {
                                sunstruckEntity.setItemSlot(slot, this.zombie.getItemBySlot(slot).copy());
                            }
                        }
                        this.zombie.playSound(SoundEvents.ZOMBIE_CONVERTED_TO_DROWNED, 1.0f, 1.0f);
                        this.zombie.playSound(SoundEvents.AMETHYST_BLOCK_CHIME, 1.0f, 0.8f);
                        this.zombie.remove(Entity.RemovalReason.DISCARDED);
                        this.zombie.level().addFreshEntity(sunstruck);
                        this.transformCounter = 0;
                    }
                    ++this.transformCounter;
                }
            }
        });
    }
}

