/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.entity;

import javax.annotation.Nullable;
import net.mcreator.concoction.init.ConcoctionModEntities;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SunstruckArrowEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)ConcoctionModItems.OVERGROWN_ARROW.get());
    private int knockback = 0;
    private boolean tripleFired = false;
    private boolean creativeShot = false;

    public SunstruckArrowEntity(EntityType<? extends SunstruckArrowEntity> type, Level world) {
        super(type, world);
    }

    public SunstruckArrowEntity(EntityType<? extends SunstruckArrowEntity> type, LivingEntity shooter, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, shooter, world, PROJECTILE_ITEM, firedFromWeapon);
        this.tripleFired = SunstruckArrowEntity.hasMultiShot(firedFromWeapon);
        if (shooter instanceof Player) {
            Player p = (Player)shooter;
            this.creativeShot = p.getAbilities().instabuild;
        }
    }

    private static boolean hasMultiShot(@Nullable ItemStack stack) {
        ItemEnchantments stored;
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        ItemEnchantments ench = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (ench != null) {
            for (Holder holder : ench.keySet()) {
                if (!holder.is(Enchantments.MULTISHOT) || ench.getLevel(holder) <= 0) continue;
                return true;
            }
        }
        if ((stored = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)) != null) {
            for (Holder holder : stored.keySet()) {
                if (!holder.is(Enchantments.MULTISHOT) || stored.getLevel(holder) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void tick() {
        Entity entity;
        super.tick();
        if (this.tickCount == 1 && (entity = this.getOwner()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)entity;
            if (this.creativeShot) {
                this.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                return;
            }
            if (this.tripleFired) {
                Vec3 look = shooter.getViewVector(1.0f);
                double dot = look.normalize().dot(this.getDeltaMovement().normalize());
                boolean isCentral = dot > Math.cos(Math.toRadians(5.0));
                this.pickup = isCentral ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
            } else if (shooter instanceof Player) {
                Player p = (Player)shooter;
                this.pickup = p.getAbilities().instabuild ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
            } else {
                this.pickup = AbstractArrow.Pickup.ALLOWED;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ConcoctionModItems.OVERGROWN_ARROW.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
        if (!this.level().isClientSide) {
            int DURATION = 400;
            int MAX_AMP = 4;
            DeferredHolder<MobEffect, MobEffect> effect = ConcoctionModMobEffects.SUNSTRUCK_EFFECT;
            MobEffectInstance cur = entity.getEffect(effect);
            int amp = cur == null ? 0 : Math.min(cur.getAmplifier() + 1, 4);
            entity.addEffect(new MobEffectInstance(effect, 400, amp, false, true, true));
        }
    }

    public void setKnockback(int knockback) {
        this.knockback = Math.max(0, knockback);
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if (this.knockback > 0) {
            double resist = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 flatDir = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
            Vec3 force = flatDir.scale((double)this.knockback * 0.6 * resist);
            if (force.lengthSqr() > 0.0) {
                livingEntity.push(force.x, 0.1, force.z);
            }
        }
    }

    public static SunstruckArrowEntity shoot(Level world, LivingEntity shooter, RandomSource random) {
        return SunstruckArrowEntity.shoot(world, shooter, random, 1.0f, 5.0, 5);
    }

    public static SunstruckArrowEntity shoot(Level world, LivingEntity shooter, RandomSource random, float pullingPower) {
        return SunstruckArrowEntity.shoot(world, shooter, random, pullingPower * 1.0f, 5.0, 5);
    }

    public static SunstruckArrowEntity shoot(Level world, LivingEntity shooter, RandomSource random, float power, double baseDamage, int knockback) {
        ItemStack firedFrom = shooter.getUseItem();
        if (firedFrom.isEmpty()) {
            firedFrom = shooter.getMainHandItem();
        }
        if (firedFrom.isEmpty()) {
            firedFrom = shooter.getOffhandItem();
        }
        SunstruckArrowEntity arrow = new SunstruckArrowEntity((EntityType<? extends SunstruckArrowEntity>)((EntityType)ConcoctionModEntities.SUNSTRUCK_ARROW.get()), shooter, world, firedFrom);
        arrow.shoot(shooter.getViewVector((float)1.0f).x, shooter.getViewVector((float)1.0f).y, shooter.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        arrow.setSilent(true);
        arrow.setCritArrow(false);
        arrow.setBaseDamage(baseDamage);
        arrow.setKnockback(knockback);
        world.addFreshEntity((Entity)arrow);
        world.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return arrow;
    }

    public static SunstruckArrowEntity shoot(LivingEntity shooter, LivingEntity target) {
        ItemStack firedFrom = shooter.getUseItem();
        if (firedFrom.isEmpty()) {
            firedFrom = shooter.getMainHandItem();
        }
        if (firedFrom.isEmpty()) {
            firedFrom = shooter.getOffhandItem();
        }
        SunstruckArrowEntity arrow = new SunstruckArrowEntity((EntityType<? extends SunstruckArrowEntity>)((EntityType)ConcoctionModEntities.SUNSTRUCK_ARROW.get()), shooter, shooter.level(), firedFrom);
        double dx = target.getX() - shooter.getX();
        double dz = target.getZ() - shooter.getZ();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1 - arrow.getY();
        arrow.shoot(dx, dy + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        arrow.setSilent(true);
        arrow.setBaseDamage(5.0);
        arrow.setKnockback(5);
        arrow.setCritArrow(false);
        shooter.level().addFreshEntity((Entity)arrow);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return arrow;
    }
}

