/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class CreamyBoostHandler {
    private static final ThreadLocal<Boolean> REENTRY = ThreadLocal.withInitial(() -> false);
    private static final Map<UUID, Set<String>> BOOSTED = new HashMap<UUID, Set<String>>();
    private static final String NBT_KEY = "concoction_creamy_boosted";

    private static String keyOf(Holder<MobEffect> holder) {
        return holder.unwrapKey().map(k -> k.location().toString()).orElse(null);
    }

    private static Set<String> getBoostedSet(LivingEntity e) {
        return BOOSTED.computeIfAbsent(e.getUUID(), u -> new HashSet<String>(CreamyBoostHandler.readPersisted(e)));
    }

    private static void setBoostedSet(LivingEntity e, Set<String> set) {
        BOOSTED.put(e.getUUID(), set);
        CreamyBoostHandler.writePersisted(e, set);
    }

    private static boolean wasBoosted(LivingEntity e, Holder<MobEffect> holder) {
        String id = CreamyBoostHandler.keyOf(holder);
        if (id == null) {
            return true;
        }
        return CreamyBoostHandler.getBoostedSet(e).contains(id);
    }

    private static void markBoosted(LivingEntity e, Holder<MobEffect> holder) {
        String id = CreamyBoostHandler.keyOf(holder);
        if (id == null) {
            return;
        }
        Set<String> set = CreamyBoostHandler.getBoostedSet(e);
        if (set.add(id)) {
            CreamyBoostHandler.setBoostedSet(e, set);
        }
    }

    private static void unmarkBoosted(LivingEntity e, Holder<MobEffect> holder) {
        String id = CreamyBoostHandler.keyOf(holder);
        if (id == null) {
            return;
        }
        Set<String> set = CreamyBoostHandler.getBoostedSet(e);
        if (set.remove(id)) {
            CreamyBoostHandler.setBoostedSet(e, set);
        }
    }

    private static Set<String> readPersisted(LivingEntity e) {
        CompoundTag tag = e.getPersistentData();
        HashSet<String> out = new HashSet<String>();
        if (tag != null && tag.contains(NBT_KEY, 9)) {
            ListTag list = tag.getList(NBT_KEY, 8);
            for (Tag t : list) {
                if (!(t instanceof StringTag)) continue;
                StringTag st = (StringTag)t;
                out.add(st.getAsString());
            }
        }
        return out;
    }

    private static void writePersisted(LivingEntity e, Set<String> set) {
        CompoundTag tag = e.getPersistentData();
        ListTag list = new ListTag();
        for (String s : set) {
            list.add((Object)StringTag.valueOf((String)s));
        }
        tag.put(NBT_KEY, (Tag)list);
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player p = event.getEntity();
        if (p == null || p.level().isClientSide()) {
            return;
        }
        BOOSTED.put(p.getUUID(), CreamyBoostHandler.readPersisted((LivingEntity)p));
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player oldP = event.getOriginal();
        Player newP = event.getEntity();
        if (newP == null || newP.level().isClientSide()) {
            return;
        }
        if (oldP == null) {
            return;
        }
        CompoundTag oldTag = oldP.getPersistentData();
        if (oldTag != null && oldTag.contains(NBT_KEY, 9)) {
            newP.getPersistentData().put(NBT_KEY, (Tag)oldTag.getList(NBT_KEY, 8).copy());
        }
        BOOSTED.put(newP.getUUID(), CreamyBoostHandler.readPersisted((LivingEntity)newP));
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity e = event.getEntity();
        if (e == null || e.level().isClientSide()) {
            return;
        }
        Holder removed = event.getEffect();
        if (!removed.is(ConcoctionModMobEffects.CREAMY)) {
            CreamyBoostHandler.unmarkBoosted(e, (Holder<MobEffect>)removed);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity e = event.getEntity();
        if (e == null || e.level().isClientSide()) {
            return;
        }
        MobEffectInstance inst = event.getEffectInstance();
        if (inst == null) {
            return;
        }
        Holder expired = inst.getEffect();
        if (!expired.is(ConcoctionModMobEffects.CREAMY)) {
            CreamyBoostHandler.unmarkBoosted(e, (Holder<MobEffect>)expired);
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (Boolean.TRUE.equals(REENTRY.get())) {
            return;
        }
        LivingEntity entity = event.getEntity();
        MobEffectInstance added = event.getEffectInstance();
        if (entity == null || added == null || entity.level().isClientSide()) {
            return;
        }
        Holder addedHolder = added.getEffect();
        if (!addedHolder.is(ConcoctionModMobEffects.CREAMY)) {
            return;
        }
        int bonus = added.getAmplifier() + 1;
        CreamyBoostHandler.markBoosted(entity, ConcoctionModMobEffects.CREAMY);
        ArrayList snapshot = new ArrayList(entity.getActiveEffects());
        for (MobEffectInstance inst : snapshot) {
            Holder h;
            if (inst == added || (h = inst.getEffect()).is(ConcoctionModMobEffects.CREAMY) || CreamyBoostHandler.wasBoosted(entity, (Holder<MobEffect>)h)) continue;
            CreamyBoostHandler.boostOnce(entity, inst, bonus);
            CreamyBoostHandler.markBoosted(entity, (Holder<MobEffect>)h);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        BOOSTED.computeIfAbsent(player.getUUID(), u -> new HashSet<String>(CreamyBoostHandler.readPersisted((LivingEntity)player)));
        MobEffectInstance creamy = player.getEffect(ConcoctionModMobEffects.CREAMY);
        if (creamy == null) {
            return;
        }
        int bonus = creamy.getAmplifier() + 1;
        CreamyBoostHandler.markBoosted((LivingEntity)player, ConcoctionModMobEffects.CREAMY);
        ArrayList snapshot = new ArrayList(player.getActiveEffects());
        for (MobEffectInstance inst : snapshot) {
            Holder h = inst.getEffect();
            if (h.is(ConcoctionModMobEffects.CREAMY) || CreamyBoostHandler.wasBoosted((LivingEntity)player, (Holder<MobEffect>)h)) continue;
            CreamyBoostHandler.boostOnce((LivingEntity)player, inst, bonus);
            CreamyBoostHandler.markBoosted((LivingEntity)player, (Holder<MobEffect>)h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void boostOnce(LivingEntity entity, MobEffectInstance inst, int bonus) {
        if (Boolean.TRUE.equals(REENTRY.get())) {
            return;
        }
        Holder h = inst.getEffect();
        MobEffectInstance upgraded = new MobEffectInstance(h, inst.getDuration(), inst.getAmplifier() + bonus, inst.isAmbient(), inst.isVisible(), inst.showIcon());
        REENTRY.set(true);
        try {
            entity.removeEffect(h);
            entity.addEffect(upgraded);
        }
        finally {
            REENTRY.set(false);
        }
    }
}

