/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mcreator.concoction.init.ConcoctionModDataComponents;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.mcreator.concoction.item.OvergrownAxeItem;
import net.mcreator.concoction.item.OvergrownHoeItem;
import net.mcreator.concoction.item.OvergrownPickaxeItem;
import net.mcreator.concoction.item.OvergrownShovelItem;
import net.mcreator.concoction.item.OvergrownSwordItem;
import net.mcreator.concoction.item.food.types.FoodEffectComponent;
import net.mcreator.concoction.item.food.types.FoodEffectType;
import net.mcreator.concoction.utils.ColoredVertexConsumer;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class PlayerHandler {
    private static int tickCounter = 0;
    private static final int UPDATE_INTERVAL = 200;
    private static final int RENDER_DELAY_TICKS = 15;
    private static final int SLEEP_TIMER_DURATION = 9600;
    private static final int BASE_REGEN_INTERVAL = 80;
    private static final double BASE_SPEED_MULTIPLIER = 0.1;
    private static final int MAX_SURVIVAL_HP = 5;
    private static final Map<UUID, Long> playerSpecialStateExitTimes = new HashMap<UUID, Long>();
    private static final ResourceKey<DamageType> SPICY_DAMAGE_KEY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"concoction:spicy_damage"));
    private static final Map<UUID, Boolean> shouldRenderSpicyEffect = new HashMap<UUID, Boolean>();
    private static final TagKey<Item> SOULLAND_RELATION = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"concoction:soulland_relation"));
    private static final TagKey<Block> WILDLIFE_PLANTS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"concoction:wildlife_plants"));
    private static final TagKey<Item> SPECIAL_FOOD = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:foods/dish"));
    private static final TagKey<Item> SPECIAL_SOUP = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:foods/soup"));
    private static final TagKey<EntityType<?>> FARM_ANIMALS = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"c:farm_animals"));

    @SubscribeEvent
    public static void playerInventoryChangeEvent(PlayerContainerEvent.Close event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            boolean hasTaggedItem = false;
            for (ItemStack stack : player2.getInventory().items) {
                if (stack.isEmpty() || !stack.is(SOULLAND_RELATION)) continue;
                hasTaggedItem = true;
                break;
            }
            if (hasTaggedItem) {
                Utils.addAchievement(player2, "concoction:nether_mutation");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEatItem(LivingEntityUseItemEvent.Finish event) {
        FoodEffectComponent[] components;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack itemStack = event.getItem();
        if (itemStack.is(SPECIAL_FOOD) || itemStack.is(SPECIAL_SOUP)) {
            Utils.addAchievement(player, "concoction:eat_dish");
        }
        for (FoodEffectComponent comp : components = new FoodEffectComponent[]{(FoodEffectComponent)itemStack.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT.value()), (FoodEffectComponent)itemStack.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_2.value()), (FoodEffectComponent)itemStack.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_3.value()), (FoodEffectComponent)itemStack.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_4.value()), (FoodEffectComponent)itemStack.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_5.value())}) {
            if (comp == null || comp.type() != FoodEffectType.BREAKFAST || player.getPersistentData().getInt("sleep_timer") <= 0) continue;
            Utils.addAchievement(player, "concoction:breakfast_check");
            break;
        }
    }

    @SubscribeEvent
    public static void playerBreaksBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack itemStack = event.getPlayer().getInventory().getSelected();
            if (itemStack.getItem() instanceof OvergrownHoeItem) {
                event.setCanceled(itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1);
            }
            if (event.getState().is(WILDLIFE_PLANTS)) {
                Utils.addAchievement(player2, "concoction:new_crops");
            }
        }
    }

    @SubscribeEvent
    public static void playerBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemStack = event.getEntity().getInventory().getSelected();
        if ((itemStack.getItem() instanceof OvergrownHoeItem || itemStack.getItem() instanceof OvergrownAxeItem || itemStack.getItem() instanceof OvergrownPickaxeItem || itemStack.getItem() instanceof OvergrownShovelItem || itemStack.getItem() instanceof OvergrownSwordItem) && itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getEntity().getInventory().getSelected();
        if ((itemStack.getItem() instanceof OvergrownHoeItem || itemStack.getItem() instanceof OvergrownAxeItem || itemStack.getItem() instanceof OvergrownShovelItem) && itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerBreaksBlock(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getEntity().getInventory().getSelected();
        if ((itemStack.getItem() instanceof OvergrownHoeItem || itemStack.getItem() instanceof OvergrownAxeItem || itemStack.getItem() instanceof OvergrownPickaxeItem || itemStack.getItem() instanceof OvergrownShovelItem) && itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        player.getPersistentData().putInt("sleep_timer", 9600);
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        UUID playerUUID = player.getUUID();
        if (player.hasEffect(ConcoctionModMobEffects.SPICY) && shouldRenderSpicyEffect.getOrDefault(playerUUID, false).booleanValue()) {
            PlayerRenderer playerRenderer = event.getRenderer();
            PlayerModel model = (PlayerModel)playerRenderer.getModel();
            boolean oldHeadVisible = model.head.visible;
            boolean oldHatVisible = model.hat.visible;
            model.head.visible = false;
            model.hat.visible = false;
            player.getPersistentData().putBoolean("spicy_head_visible", oldHeadVisible);
            player.getPersistentData().putBoolean("spicy_hat_visible", oldHatVisible);
        }
    }

    @SubscribeEvent
    public static void onGiveExperience(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        if (player.hasEffect(ConcoctionModMobEffects.BITTERNESS)) {
            MobEffectInstance bitternessEffect = player.getEffect(ConcoctionModMobEffects.BITTERNESS);
            int experience = event.getOrb().getValue();
            event.getOrb().value = (int)((double)experience * (1.0 + 0.5 * (double)(bitternessEffect.getAmplifier() + 1)));
        }
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        UUID playerUUID = player.getUUID();
        if (player.hasEffect(ConcoctionModMobEffects.SPICY) && shouldRenderSpicyEffect.getOrDefault(playerUUID, false).booleanValue()) {
            PlayerRenderer playerRenderer = event.getRenderer();
            PlayerModel model = (PlayerModel)playerRenderer.getModel();
            boolean oldHeadVisible = player.getPersistentData().getBoolean("spicy_head_visible");
            boolean oldHatVisible = player.getPersistentData().getBoolean("spicy_hat_visible");
            model.head.visible = oldHeadVisible;
            model.hat.visible = oldHatVisible;
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource bufferSource = event.getMultiBufferSource();
            int packedLight = event.getPackedLight();
            poseStack.pushPose();
            float scale = 1.0f;
            poseStack.scale(scale, -scale, -scale);
            poseStack.translate(0.0, -1.4, 0.0);
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)playerRenderer.getTextureLocation((AbstractClientPlayer)player)));
            float netHeadYaw = event.getPartialTick() == 0.0f ? player.yHeadRot : Mth.lerp((float)event.getPartialTick(), (float)player.yHeadRotO, (float)player.yHeadRot);
            float headPitch = event.getPartialTick() == 0.0f ? player.getXRot() : Mth.lerp((float)event.getPartialTick(), (float)player.xRotO, (float)player.getXRot());
            model.setupAnim((LivingEntity)((AbstractClientPlayer)player), 0.0f, 0.0f, event.getPartialTick(), netHeadYaw, headPitch);
            float time = (player.level().getGameTime() + (long)player.getId()) % 50L;
            float pulse = 0.3f + 0.4f * (0.5f * (1.0f + Mth.sin((float)((float)((double)(time / 50.0f * 2.0f) * Math.PI)))));
            ColoredVertexConsumer coloredConsumer = new ColoredVertexConsumer(vertexConsumer, 1.0f, pulse, pulse);
            model.head.render(poseStack, (VertexConsumer)coloredConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            model.hat.render(poseStack, (VertexConsumer)coloredConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public static void entityDied(LivingDeathEvent event) {
        LivingEntity damagedEntity;
        Level world;
        LivingEntity entity;
        ItemStack itemStack;
        int enchantmentLevel;
        Entity source = event.getSource().getEntity();
        if (source instanceof LivingEntity && (enchantmentLevel = (itemStack = (entity = (LivingEntity)source).getItemInHand(InteractionHand.MAIN_HAND)).getEnchantmentLevel((Holder)(world = entity.level()).registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"concoction:butchering"))))) > 0 && (damagedEntity = event.getEntity()).getType().is(FARM_ANIMALS) && new Random().nextInt(0, 10) < enchantmentLevel) {
            ItemEntity entityToSpawn;
            if (damagedEntity instanceof Chicken) {
                entityToSpawn = new ItemEntity(world, damagedEntity.getX(), damagedEntity.getY() + 0.5, damagedEntity.getZ(), new ItemStack((ItemLike)Items.FEATHER, 1));
                entityToSpawn.setPickUpDelay(10);
                world.addFreshEntity((Entity)entityToSpawn);
            }
            if (damagedEntity instanceof Cow) {
                entityToSpawn = new ItemEntity(world, damagedEntity.getX(), damagedEntity.getY() + 0.5, damagedEntity.getZ(), new ItemStack((ItemLike)Items.LEATHER, 1));
                entityToSpawn.setPickUpDelay(10);
                world.addFreshEntity((Entity)entityToSpawn);
            }
            entityToSpawn = new ItemEntity(world, damagedEntity.getX(), damagedEntity.getY() + 0.5, damagedEntity.getZ(), new ItemStack((ItemLike)ConcoctionModItems.ANIMAL_FAT.get(), 1));
            entityToSpawn.setPickUpDelay(10);
            world.addFreshEntity((Entity)entityToSpawn);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            player.getPersistentData().putInt("sleep_timer", 0);
        }
        if (!((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        player = (Player)livingEntity;
        if (player.hasEffect(ConcoctionModMobEffects.BREAKFAST) && player.getPersistentData().getInt("sleep_timer") > 0) {
            MobEffectInstance effect = player.getEffect(ConcoctionModMobEffects.BREAKFAST);
            int level = effect.getAmplifier() + 1;
            int minHP = Math.min(level, 5);
            if (player.getHealth() >= player.getMaxHealth() * 0.9f) {
                player.setHealth((float)minHP);
                event.setCanceled(true);
                player.level().broadcastEntityEvent((Entity)player, (byte)35);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.getPersistentData().getInt("sleep_timer") > 0 && player.hasEffect(ConcoctionModMobEffects.BREAKFAST)) {
            MobEffectInstance effect = player.getEffect(ConcoctionModMobEffects.BREAKFAST);
            int level = effect.getAmplifier() + 1;
            player.heal(1.0f);
            float wouldBeHealth = player.getHealth() - event.getAmount();
            int minHP = Math.min(level, 5);
            if (wouldBeHealth <= 0.0f && player.getHealth() > player.getMaxHealth() * 0.9f) {
                event.setAmount(player.getHealth() - (float)minHP);
            }
        }
    }

    @SubscribeEvent
    public static void entityAttacked(LivingIncomingDamageEvent event) {
        ServerPlayer player;
        Level world;
        LivingEntity entity;
        ItemStack itemStack;
        int enchantmentLevel;
        Player p;
        Entity source = event.getSource().getEntity();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (p = (Player)livingEntity).hasEffect(ConcoctionModMobEffects.CREAMY) && event.getSource().is(SPICY_DAMAGE_KEY)) {
            event.setCanceled(true);
            return;
        }
        if (source instanceof LivingEntity && (enchantmentLevel = (itemStack = (entity = (LivingEntity)source).getItemInHand(InteractionHand.MAIN_HAND)).getEnchantmentLevel((Holder)(world = entity.level()).registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"concoction:butchering"))))) > 0) {
            LivingEntity damagedEntity = event.getEntity();
            if (damagedEntity.getType().is(FARM_ANIMALS)) {
                event.setAmount((float)((double)event.getAmount() + (double)enchantmentLevel * 2.5));
            }
            System.out.println(event.getAmount());
        }
        if (source instanceof ServerPlayer && ((itemStack = (player = (ServerPlayer)source).getInventory().getSelected()).getItem() instanceof OvergrownHoeItem || itemStack.getItem() instanceof OvergrownAxeItem || itemStack.getItem() instanceof OvergrownPickaxeItem || itemStack.getItem() instanceof OvergrownShovelItem || itemStack.getItem() instanceof OvergrownSwordItem) && itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerTickEvent(PlayerTickEvent.Pre event) {
        boolean isInSpecialState;
        int timer;
        ++tickCounter;
        Player player = event.getEntity();
        UUID playerUUID = player.getUUID();
        if (player.getPersistentData().getInt("sleep_timer") > 0 && player.hasEffect(ConcoctionModMobEffects.BREAKFAST)) {
            MobEffectInstance effect = player.getEffect(ConcoctionModMobEffects.BREAKFAST);
            int level = effect.getAmplifier() + 1;
            int regenInterval = Math.max(1, 80 - 10 * (level - 1));
            int regenCounter = player.getPersistentData().getInt("breakfast_regen_counter") + 1;
            if (regenCounter >= regenInterval) {
                if (player.getHealth() < player.getMaxHealth()) {
                    player.heal(1.0f);
                }
                regenCounter = 0;
            }
            player.getPersistentData().putInt("breakfast_regen_counter", regenCounter);
        }
        if ((timer = player.getPersistentData().getInt("sleep_timer")) > 0) {
            player.getPersistentData().putInt("sleep_timer", --timer);
            if (timer == 1) {
                player.displayClientMessage((Component)Component.translatable((String)"message.concoction.tired"), true);
            } else if (timer == 9599) {
                player.displayClientMessage((Component)Component.translatable((String)"message.concoction.rested"), true);
            }
        }
        boolean bl = isInSpecialState = player.isFallFlying() || player.isSwimming() || player.getPose() == Pose.SWIMMING;
        if (!isInSpecialState && player.getPersistentData().getBoolean("was_in_special_state")) {
            playerSpecialStateExitTimes.put(playerUUID, player.level().getGameTime());
        }
        player.getPersistentData().putBoolean("was_in_special_state", isInSpecialState);
        if (player.hasEffect(ConcoctionModMobEffects.SPICY)) {
            boolean shouldRender;
            boolean bl2 = shouldRender = !PlayerHandler.isPlayerInSpecialState(player);
            if (!shouldRenderSpicyEffect.containsKey(playerUUID) || shouldRenderSpicyEffect.get(playerUUID) != shouldRender) {
                shouldRenderSpicyEffect.put(playerUUID, shouldRender);
            }
        } else {
            shouldRenderSpicyEffect.remove(playerUUID);
        }
        if (tickCounter > 200) {
            ItemStack mainHandItem = player.getInventory().getSelected();
            if (!player.level().isClientSide() && player.level().isDay() && player.level().canSeeSky(player.blockPosition().above()) && player instanceof ServerPlayer) {
                int multiplier = 1;
                if (player.hasEffect(ConcoctionModMobEffects.PHOTOSYNTHESIS)) {
                    multiplier = 2;
                }
                PlayerHandler.checkAndRepairItem(mainHandItem, multiplier, player.level());
                ItemStack offHandItem = player.getOffhandItem();
                PlayerHandler.checkAndRepairItem(offHandItem, multiplier, player.level());
                tickCounter = 0;
            }
        }
    }

    private static void checkAndRepairItem(ItemStack itemStack, int multiplier, Level level) {
        int currentDamage;
        if (itemStack.isEmpty()) {
            return;
        }
        if ((itemStack.getItem() instanceof OvergrownHoeItem || itemStack.getItem() instanceof OvergrownAxeItem || itemStack.getItem() instanceof OvergrownPickaxeItem || itemStack.getItem() instanceof OvergrownShovelItem || itemStack.getItem() instanceof OvergrownSwordItem) && (currentDamage = itemStack.getDamageValue()) > 0) {
            if (itemStack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.MENDING)) != 0 || itemStack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.UNBREAKING)) != 0) {
                return;
            }
            int newDamage = Math.max(0, currentDamage - 1 * multiplier);
            if (newDamage != currentDamage) {
                itemStack.setDamageValue(newDamage);
            }
        }
    }

    private static boolean isPlayerInSpecialState(Player player) {
        Long exitTime;
        boolean currentlyInSpecialState;
        UUID playerUUID = player.getUUID();
        boolean bl = currentlyInSpecialState = player.isFallFlying() || player.isSwimming() || player.getPose() == Pose.SWIMMING;
        if (!currentlyInSpecialState && (exitTime = playerSpecialStateExitTimes.get(playerUUID)) != null) {
            long currentTime = player.level().getGameTime();
            if (currentTime - exitTime < 15L) {
                return true;
            }
            playerSpecialStateExitTimes.remove(playerUUID);
        }
        return currentlyInSpecialState;
    }
}

