/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.item;

import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OvergrownHoeItem
extends HoeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 131;
        }

        public float getSpeed() {
            return 6.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 15;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public OvergrownHoeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)0.0f, (float)-3.0f)));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 1) {
            return false;
        }
        boolean result = super.hurtEnemy(itemstack, entity, sourceentity);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1) {
            itemstack.setDamageValue(itemstack.getMaxDamage() - 1);
            return false;
        }
        return result;
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 1) {
            return false;
        }
        boolean result = super.mineBlock(itemstack, world, blockstate, pos, entity);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1) {
            itemstack.setDamageValue(itemstack.getMaxDamage() - 1);
            return false;
        }
        return result;
    }

    public int getBarColor(ItemStack stack) {
        return Utils.getColor(stack);
    }
}

