/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.item;

import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OvergrownSwordItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 131;
        }

        public float getSpeed() {
            return 6.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 15;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public OvergrownSwordItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)4.0f, (float)-2.2f)));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity target, LivingEntity attacker) {
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 1) {
            return false;
        }
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 2) {
            itemstack.setDamageValue(itemstack.getMaxDamage() - 1);
            return false;
        }
        boolean result = super.hurtEnemy(itemstack, target, attacker);
        if (result && !attacker.level().isClientSide && attacker.getRandom().nextFloat() < 0.5f) {
            OvergrownSwordItem.applySunstruck(target);
        }
        return result;
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 1) {
            return false;
        }
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 2) {
            itemstack.setDamageValue(itemstack.getMaxDamage() - 1);
            return false;
        }
        return super.mineBlock(itemstack, world, blockstate, pos, entity);
    }

    public int getBarColor(ItemStack stack) {
        return Utils.getColor(stack);
    }

    private static void applySunstruck(LivingEntity target) {
        if (target == null) {
            return;
        }
        int DURATION_TICKS = 240;
        int MAX_AMP = 5;
        MobEffectInstance current = target.getEffect(ConcoctionModMobEffects.SUNSTRUCK_EFFECT);
        int newAmp = 0;
        if (current != null) {
            newAmp = Math.min(current.getAmplifier() + 1, 5);
        }
        MobEffectInstance updated = new MobEffectInstance(ConcoctionModMobEffects.SUNSTRUCK_EFFECT, 240, newAmp, false, true, true);
        target.addEffect(updated);
    }
}

