/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.item;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.concoction.init.ConcoctionModDataComponents;
import net.mcreator.concoction.item.food.types.FoodEffectComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class TastefulItem
extends Item {
    public TastefulItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.concoction.hold_key", (Object[])new Object[]{Component.keybind((String)"key.sneak")}).withStyle(ChatFormatting.DARK_GRAY));
            return;
        }
        List<Component> tastes = this.collectTastes(stack);
        if (!tastes.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.concoction.tastes_header").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.addAll(tastes);
            tooltip.add((Component)Component.empty());
        }
        tooltip.add((Component)Component.translatable((String)this.getDescriptionKeyForThisItem()).withStyle(ChatFormatting.GRAY));
    }

    private List<Component> collectTastes(ItemStack stack) {
        ArrayList<Component> tastes = new ArrayList<Component>();
        this.addTasteIfPresent(stack, tastes, (DataComponentType<FoodEffectComponent>)((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT.value()));
        this.addTasteIfPresent(stack, tastes, (DataComponentType<FoodEffectComponent>)((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_2.value()));
        this.addTasteIfPresent(stack, tastes, (DataComponentType<FoodEffectComponent>)((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_3.value()));
        this.addTasteIfPresent(stack, tastes, (DataComponentType<FoodEffectComponent>)((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_4.value()));
        this.addTasteIfPresent(stack, tastes, (DataComponentType<FoodEffectComponent>)((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_5.value()));
        return tastes;
    }

    private void addTasteIfPresent(ItemStack stack, List<Component> list, DataComponentType<FoodEffectComponent> type) {
        FoodEffectComponent comp = (FoodEffectComponent)stack.get(type);
        if (comp != null) {
            list.add(comp.type().getTooltip(comp.level(), comp.duration(), comp.isHidden()));
        }
    }

    private String getDescriptionKeyForThisItem() {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this);
        String ns = id == null ? "minecraft" : id.getNamespace();
        String path = id == null ? "unknown" : id.getPath();
        return "description.concoction." + ns + "." + path;
    }
}

