/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.item.food.types;

import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public enum FoodEffectType implements StringRepresentable
{
    SWEET("sweet"),
    SPICY("spicy"),
    MINTY("minty"),
    GLOW("glow"),
    INSTABILITY("instability"),
    SALTY("saltness"),
    FLAMING("fiery_touch"),
    WARM("warming"),
    BITTER("bitterness"),
    BREAKFAST("breakfast"),
    SUNSTRUCK("sunstruck"),
    PHOTOSYNTHESIS("photosynthesis"),
    CREAMY("creamy"),
    HEAL("heal");

    private final String name;

    private FoodEffectType(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public static FoodEffectType getByName(String name) {
        return switch (name) {
            case "sweet" -> SWEET;
            case "spicy" -> SPICY;
            case "minty" -> MINTY;
            case "glow" -> GLOW;
            case "instability" -> INSTABILITY;
            case "saltness" -> SALTY;
            case "fiery_touch" -> FLAMING;
            case "warming" -> WARM;
            case "bitterness" -> BITTER;
            case "breakfast" -> BREAKFAST;
            case "sunstruck" -> SUNSTRUCK;
            case "photosynthesis" -> PHOTOSYNTHESIS;
            case "creamy" -> CREAMY;
            case "heal" -> HEAL;
            default -> throw new IllegalArgumentException("Invalid name: " + name);
        };
    }

    public static MobEffectInstance getEffect(FoodEffectType type, int level, int duration, boolean isHidden, LivingEntity entity) {
        switch (type.ordinal()) {
            case 13: {
                return null;
            }
            case 0: {
                return new MobEffectInstance(ConcoctionModMobEffects.SWEETNESS, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 1: {
                return new MobEffectInstance(ConcoctionModMobEffects.SPICY, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 2: {
                return new MobEffectInstance(ConcoctionModMobEffects.MINTY_BREATH, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 3: {
                return new MobEffectInstance(MobEffects.GLOWING, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 4: {
                return new MobEffectInstance(ConcoctionModMobEffects.INSTABILITY, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 5: {
                return new MobEffectInstance(ConcoctionModMobEffects.SALTNESS, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 6: {
                return new MobEffectInstance(ConcoctionModMobEffects.FIERY_TOUCH, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 7: {
                return new MobEffectInstance(ConcoctionModMobEffects.WARMING, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 8: {
                return new MobEffectInstance(ConcoctionModMobEffects.BITTERNESS, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 9: {
                return new MobEffectInstance(ConcoctionModMobEffects.BREAKFAST, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 10: {
                return new MobEffectInstance(ConcoctionModMobEffects.SUNSTRUCK_EFFECT, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 11: {
                return new MobEffectInstance(ConcoctionModMobEffects.PHOTOSYNTHESIS, duration * 20, level - 1, false, !isHidden, true, null);
            }
            case 12: {
                return new MobEffectInstance(ConcoctionModMobEffects.CREAMY, duration * 20, level - 1, false, !isHidden, true, null);
            }
        }
        return null;
    }

    public static void applyInstantEffect(FoodEffectType type, LivingEntity entity, int level) {
        if (type == HEAL && entity instanceof Player) {
            Player player = (Player)entity;
            player.heal((float)level * 2.0f);
            if (!player.level().isClientSide()) {
                return;
            }
            double x = player.getX();
            double y = player.getY() + (double)(player.getEyeHeight() / 2.0f);
            double z = player.getZ();
            int particleCount = 5;
            double radiusX = 1.5;
            double radiusY = 1.0;
            double radiusZ = 1.5;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (player.getRandom().nextDouble() - 0.5) * 2.0 * radiusX;
                double offsetY = (player.getRandom().nextDouble() - 0.5) * 2.0 * radiusY;
                double offsetZ = (player.getRandom().nextDouble() - 0.5) * 2.0 * radiusZ;
                player.level().addParticle((ParticleOptions)ParticleTypes.HEART, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.05, 0.0);
            }
        }
    }

    public Component getTooltip(int level, int duration, boolean isHidden) {
        if (this == HEAL) {
            MutableComponent effectName = Component.translatable((String)"taste.concoction.heal").withStyle(ChatFormatting.GRAY);
            MutableComponent healInfo = Component.literal((String)" (x").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(level)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\u2764").withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.GRAY));
            return effectName.append((Component)healInfo);
        }
        MutableComponent effectName = Component.translatable((String)("taste.concoction." + this.name)).withStyle(ChatFormatting.GRAY);
        String romanLevel = level > 1 ? FoodEffectType.toRoman(level) : "";
        int totalSeconds = duration;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        String timeFormatted = String.format("%d:%02d", minutes, seconds);
        MutableComponent levelAndTime = Component.literal((String)((String)(romanLevel.isEmpty() ? "" : " " + romanLevel) + " (" + timeFormatted + ")")).withStyle(ChatFormatting.GRAY);
        return effectName.append((Component)levelAndTime);
    }

    private static String toRoman(int number) {
        String[] romans = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (number >= 1 && number <= 10) {
            return romans[number - 1];
        }
        return String.valueOf(number);
    }
}

