/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.mixins;

import net.mcreator.concoction.init.ConcoctionModGameRules;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.interfaces.ICowMilkLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cow.class})
public class CowMixin
implements ICowMilkLevel {
    @Unique
    private int concoction$milkLevel = 3;
    @Unique
    private long concoction$lastMilkedTime = 0L;

    @Override
    public int concoction$getMilkLevel() {
        return this.concoction$milkLevel;
    }

    @Override
    public void concoction$setMilkLevel(int level) {
        this.concoction$milkLevel = Math.max(0, Math.min(3, level));
    }

    @Override
    public void concoction$incrementMilkLevel() {
        this.concoction$setMilkLevel(this.concoction$milkLevel + 1);
    }

    @Override
    public void concoction$decrementMilkLevel() {
        this.concoction$setMilkLevel(this.concoction$milkLevel - 1);
    }

    @Override
    public long concoction$getLastMilkedTime() {
        return this.concoction$lastMilkedTime;
    }

    @Override
    public void concoction$setLastMilkedTime(long time) {
        this.concoction$lastMilkedTime = time;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void concoction$onMilk(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack;
        long intervalsPassed;
        Cow cow = (Cow)this;
        Level level = cow.level();
        long now = level.getGameTime();
        if (level.isClientSide) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        int milkingInterval = 2400;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int n = milkingInterval = serverLevel.getGameRules().getInt(ConcoctionModGameRules.MILKING_INTERVAL) == 0 ? 2400 : serverLevel.getGameRules().getInt(ConcoctionModGameRules.MILKING_INTERVAL);
        }
        if (cow.isBaby()) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
            return;
        }
        if (this.concoction$milkLevel < 3 && (intervalsPassed = (now - this.concoction$lastMilkedTime) / (long)milkingInterval) > 0L) {
            this.concoction$setMilkLevel(Math.min(3, this.concoction$milkLevel + (int)intervalsPassed));
            this.concoction$setLastMilkedTime(now - (now - this.concoction$lastMilkedTime) % (long)milkingInterval);
        }
        if ((stack = player.getItemInHand(hand)).getItem() == Items.BUCKET) {
            if (this.concoction$milkLevel != 3) {
                player.displayClientMessage((Component)Component.translatable((String)"message.concoction.cow_not_ready_bucket"), true);
                cir.setReturnValue((Object)InteractionResult.FAIL);
                return;
            }
            this.concoction$setMilkLevel(0);
            this.concoction$setLastMilkedTime(now);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            player.addItem(new ItemStack((ItemLike)Items.MILK_BUCKET));
            level.playSound(null, (Entity)cow, SoundEvents.COW_MILK, SoundSource.PLAYERS, 1.0f, 1.0f + (level.random.nextFloat() - 0.5f) * 0.2f);
            level.playSound(null, (Entity)cow, SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        if (stack.getItem() != Items.GLASS_BOTTLE) return;
        if (this.concoction$milkLevel <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.concoction.cow_not_ready_bottle"), true);
            cir.setReturnValue((Object)InteractionResult.FAIL);
            return;
        }
        this.concoction$decrementMilkLevel();
        this.concoction$setLastMilkedTime(now);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        player.addItem(new ItemStack((ItemLike)ConcoctionModItems.MILK_BOTTLE.asItem()));
        level.playSound(null, (Entity)cow, SoundEvents.COW_MILK, SoundSource.PLAYERS, 1.0f, 1.0f + (level.random.nextFloat() - 0.5f) * 0.2f);
        level.playSound(null, (Entity)cow, SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f);
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }
}

