/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.mixins;

import java.util.UUID;
import net.mcreator.concoction.block.SoapLayerBlock;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntitySlideTrackerMixin {
    private static final double SPEED_EPS = 0.01;
    private static final int REQUIRED_TICKS = 60;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void concoction$trackSoapSliding(CallbackInfo ci) {
        ItemEntity self = (ItemEntity)this;
        Level level = self.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        CompoundTag nbt = self.getPersistentData();
        if (!nbt.hasUUID("concoction_owner")) {
            return;
        }
        if (!self.onGround()) {
            return;
        }
        BlockPos below = BlockPos.containing((double)self.getX(), (double)(self.getY() - 0.2), (double)self.getZ());
        BlockPos above = below.above();
        BlockState aboveState = level2.getBlockState(above);
        if (!(aboveState.getBlock() instanceof SoapLayerBlock)) {
            return;
        }
        Vec3 mot = self.getDeltaMovement();
        double speed = Math.hypot(mot.x, mot.z);
        if (speed < 0.01) {
            return;
        }
        int ticks = nbt.getInt("concoction_slide_ticks") + 1;
        nbt.putInt("concoction_slide_ticks", ticks);
        if (ticks >= 60) {
            UUID ownerId = nbt.getUUID("concoction_owner");
            ServerPlayer owner = level2.getServer().getPlayerList().getPlayer(ownerId);
            if (owner != null) {
                Utils.addAchievement(owner, "concoction:slippery_slope");
            }
            nbt.remove("concoction_owner");
            nbt.remove("concoction_slide_ticks");
        }
    }
}

