/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.potion;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class SpicyMobEffect
extends MobEffect {
    private static final ResourceLocation SPICY_ATTACK_SPEED = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"spicy_attack_speed");
    private static final String NBT_TICK_KEY = "concoction_spicy_tick";

    public SpicyMobEffect() {
        super(MobEffectCategory.NEUTRAL, -46336);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void addAttributeModifiers(AttributeMap attributeMap, int amplifier) {
        AttributeInstance attackSpeedAttribute = attributeMap.getInstance(Attributes.ATTACK_SPEED);
        if (attackSpeedAttribute != null) {
            double increaseValue = (double)(amplifier + 1) * 0.15;
            AttributeModifier attackSpeedModifier = new AttributeModifier(SPICY_ATTACK_SPEED, increaseValue, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            attackSpeedAttribute.addTransientModifier(attackSpeedModifier);
        }
        super.addAttributeModifiers(attributeMap, amplifier);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        AttributeInstance attackSpeedAttribute = attributeMap.getInstance(Attributes.ATTACK_SPEED);
        if (attackSpeedAttribute != null) {
            attackSpeedAttribute.removeModifier(SPICY_ATTACK_SPEED);
        }
        super.removeAttributeModifiers(attributeMap);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level;
        if (entity.hasEffect(ConcoctionModMobEffects.CREAMY)) {
            entity.removeEffect(ConcoctionModMobEffects.SPICY);
            return false;
        }
        Level world = entity.level();
        if (entity.hasEffect(ConcoctionModMobEffects.SPICY) && world instanceof Level && !(level = world).isClientSide() && entity instanceof ServerPlayer) {
            int tickInterval;
            ServerPlayer player = (ServerPlayer)entity;
            int tickCounter = player.getPersistentData().getInt(NBT_TICK_KEY);
            if (tickCounter >= (tickInterval = Math.max(20, 60 - amplifier * 10)) && player.getHealth() > 1.0f) {
                DamageSource src = new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"concoction:spicy_damage"))));
                entity.hurt(src, 1.0f);
                tickCounter = 0;
            } else {
                ++tickCounter;
            }
            player.getPersistentData().putInt(NBT_TICK_KEY, tickCounter);
            List<Pair> harmful = entity.getActiveEffects().stream().map(eff -> new Pair((Object)eff.getEffect(), (Object)((MobEffect)eff.getEffect().value()).getCategory())).filter(pair -> pair.getSecond() == MobEffectCategory.HARMFUL).distinct().toList();
            if (harmful.size() >= 5) {
                Utils.addAchievement(player, "concoction:spicy_remove_many_debuffs");
            }
            harmful.forEach(pair -> entity.removeEffect((Holder)pair.getFirst()));
            if (player.isOnFire()) {
                Utils.addAchievement(player, "concoction:spicy_on_fire");
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }
}

