/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.mcreator.concoction.recipe.ModRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class SoapCleaningRecipe
extends CustomRecipe {
    private final CraftingBookCategory category;

    public SoapCleaningRecipe(CraftingBookCategory category) {
        super(category);
        this.category = category;
    }

    public boolean matches(CraftingInput input, Level level) {
        int soaps = 0;
        ItemStack target = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack s = input.getItem(i);
            if (s.isEmpty()) continue;
            if (this.isSoap(s)) {
                ++soaps;
                continue;
            }
            if (target.isEmpty()) {
                if (this.isSupportedTarget(s)) {
                    target = s;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (soaps != 1 || target.isEmpty()) {
            return false;
        }
        return this.canBeCleaned(target);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider lookup) {
        ShulkerBoxBlock sh;
        BlockItem bi;
        Block block;
        ItemStack target = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack s = input.getItem(i);
            if (s.isEmpty() || this.isSoap(s)) continue;
            target = s.copy();
            break;
        }
        if (target.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item item = target.getItem();
        if (target.get(DataComponents.DYED_COLOR) != null) {
            target.set(DataComponents.DYED_COLOR, null);
            return target;
        }
        if (item instanceof ShieldItem && (target.get(DataComponents.BANNER_PATTERNS) != null || target.get(DataComponents.BASE_COLOR) != null)) {
            target.set(DataComponents.BANNER_PATTERNS, null);
            target.set(DataComponents.BASE_COLOR, null);
            return target;
        }
        if (item instanceof BlockItem && (block = (bi = (BlockItem)item).getBlock()) instanceof ShulkerBoxBlock && (sh = (ShulkerBoxBlock)block).getColor() != null) {
            ItemStack cleaned = new ItemStack((ItemLike)Items.SHULKER_BOX);
            cleaned.applyComponents(target.getComponents());
            CustomData bed = (CustomData)target.get(DataComponents.BLOCK_ENTITY_DATA);
            if (bed != null) {
                cleaned.set(DataComponents.BLOCK_ENTITY_DATA, (Object)bed);
            }
            cleaned.set(DataComponents.DYED_COLOR, null);
            cleaned.setCount(1);
            return cleaned;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SOAP_CLEANING.get();
    }

    private boolean isSoap(ItemStack s) {
        return Objects.equals(BuiltInRegistries.ITEM.getKey((Object)s.getItem()).toString(), "concoction:soap");
    }

    private boolean isSupportedTarget(ItemStack s) {
        BlockItem bi;
        Item i = s.getItem();
        if (s.get(DataComponents.DYED_COLOR) != null) {
            return true;
        }
        if (i instanceof ShieldItem) {
            return true;
        }
        return i instanceof BlockItem && (bi = (BlockItem)i).getBlock() instanceof ShulkerBoxBlock;
    }

    private boolean canBeCleaned(ItemStack s) {
        BlockItem bi;
        Block block;
        Item i = s.getItem();
        if (s.get(DataComponents.DYED_COLOR) != null) {
            return true;
        }
        if (i instanceof ShieldItem) {
            return s.get(DataComponents.BANNER_PATTERNS) != null || s.get(DataComponents.BASE_COLOR) != null;
        }
        if (i instanceof BlockItem && (block = (bi = (BlockItem)i).getBlock()) instanceof ShulkerBoxBlock) {
            ShulkerBoxBlock sh = (ShulkerBoxBlock)block;
            return sh.getColor() != null;
        }
        return false;
    }

    public static class Serializer
    implements RecipeSerializer<SoapCleaningRecipe> {
        private static final MapCodec<SoapCleaningRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(r -> CraftingBookCategory.MISC)).apply((Applicative)inst, SoapCleaningRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SoapCleaningRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {}, buf -> new SoapCleaningRecipe(CraftingBookCategory.MISC));

        public MapCodec<SoapCleaningRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SoapCleaningRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

