/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.recipe.cauldron;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcreator.concoction.block.CookingCauldron;
import net.mcreator.concoction.init.ConcoctionModRecipes;
import net.mcreator.concoction.recipe.cauldron.CauldronBrewingRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CauldronBrewingRecipe
implements Recipe<CauldronBrewingRecipeInput> {
    private final BlockState inputState;
    private final int cookingTime;
    private final List<Ingredient> inputItems;
    private final Map<String, String> result;

    public BlockState getInputState() {
        return this.inputState;
    }

    public List<Ingredient> getInputItems() {
        return this.inputItems;
    }

    public Ingredient getIngredient(int index) {
        if (index < 0 || index >= this.inputItems.size()) {
            return Ingredient.EMPTY;
        }
        return this.inputItems.get(index);
    }

    public Map<String, String> getResult() {
        return this.result;
    }

    public CauldronBrewingRecipe(BlockState inputState, int cookingTime, List<Ingredient> inputItems, Map<String, String> result) {
        this.inputState = inputState;
        this.cookingTime = cookingTime;
        this.inputItems = inputItems;
        this.result = result;
    }

    private boolean containsAllElements(NonNullList<ItemStack> inventory, List<Ingredient> recipe) {
        NonNullList ingredientSlots = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 4; ++i) {
            ingredientSlots.set(i, (Object)((ItemStack)inventory.get(i)));
        }
        int nonEmptySlots = 0;
        for (ItemStack itemStack : ingredientSlots) {
            if (itemStack.isEmpty()) continue;
            ++nonEmptySlots;
        }
        if (nonEmptySlots != recipe.size()) {
            return false;
        }
        HashMap<Ingredient, Integer> requiredIngredients = new HashMap<Ingredient, Integer>();
        for (Ingredient ingredient : recipe) {
            requiredIngredients.merge(ingredient, 1, Integer::sum);
        }
        for (ItemStack itemStack : ingredientSlots) {
            if (itemStack.isEmpty()) continue;
            boolean matched = false;
            for (Map.Entry entry : requiredIngredients.entrySet()) {
                if ((Integer)entry.getValue() <= 0 || !((Ingredient)entry.getKey()).test(itemStack)) continue;
                entry.setValue((Integer)entry.getValue() - 1);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return requiredIngredients.values().stream().allMatch(count -> count <= 0);
    }

    public boolean matches(CauldronBrewingRecipeInput pInput, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        if (((Integer)this.inputState.getValue((Property)CookingCauldron.LEVEL)).equals(pInput.state().getValue((Property)CookingCauldron.LEVEL))) {
            return this.containsAllElements(pInput.stack(), this.inputItems);
        }
        return false;
    }

    public ItemStack assemble(CauldronBrewingRecipeInput pInput, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return null;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Items.CAULDRON);
    }

    public Map<String, String> getOutput() {
        return this.result;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ConcoctionModRecipes.CAULDRON_BREWING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ConcoctionModRecipes.CAULDRON_BREWING_RECIPE_TYPE.get();
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public static class Serializer
    implements RecipeSerializer<CauldronBrewingRecipe> {
        public static final MapCodec<CauldronBrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockState.CODEC.fieldOf("state").forGetter(CauldronBrewingRecipe::getInputState), (App)Codec.INT.fieldOf("cooking_time").orElse((Object)200).forGetter(CauldronBrewingRecipe::getCookingTime), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").forGetter(CauldronBrewingRecipe::getInputItems), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("result").forGetter(CauldronBrewingRecipe::getResult)).apply((Applicative)inst, CauldronBrewingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CauldronBrewingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), CauldronBrewingRecipe::getInputState, (StreamCodec)ByteBufCodecs.INT, CauldronBrewingRecipe::getCookingTime, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), CauldronBrewingRecipe::getInputItems, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8), CauldronBrewingRecipe::getResult, CauldronBrewingRecipe::new);

        public MapCodec<CauldronBrewingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CauldronBrewingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

