/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.recipe.oven;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcreator.concoction.init.ConcoctionModRecipes;
import net.mcreator.concoction.recipe.oven.OvenRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class OvenRecipe
implements Recipe<OvenRecipeInput> {
    private final int cookingTime;
    private final List<Ingredient> craftingIngredients;
    private final Ingredient bottleIngredient;
    private final Ingredient bowlIngredient;
    private final Map<String, String> result;

    public OvenRecipe(int cookingTime, List<Ingredient> craftingIngredients, Ingredient bottleIngredient, Ingredient bowlIngredient, Map<String, String> result) {
        this.cookingTime = cookingTime;
        this.craftingIngredients = craftingIngredients;
        this.bottleIngredient = bottleIngredient;
        this.bowlIngredient = bowlIngredient;
        this.result = result;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public List<Ingredient> getCraftingIngredients() {
        return this.craftingIngredients;
    }

    public Ingredient getBottleIngredient() {
        return this.bottleIngredient;
    }

    public Ingredient getBowlIngredient() {
        return this.bowlIngredient;
    }

    public Map<String, String> getResult() {
        return this.result;
    }

    public int getOutputCount() {
        if (this.result == null) {
            return 1;
        }
        String raw = this.result.getOrDefault("count", this.result.getOrDefault("amount", "1"));
        try {
            int v = Integer.parseInt(raw.trim());
            return Math.max(1, v);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getBowlCost() {
        return this.bowlIngredient.isEmpty() ? 0 : this.getOutputCount();
    }

    private boolean matchesIngredients(NonNullList<ItemStack> inventory) {
        NonNullList craftingSlots = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        for (int i = 1; i <= 6; ++i) {
            craftingSlots.set(i - 1, (Object)((ItemStack)inventory.get(i)));
        }
        ItemStack bottleSlot = (ItemStack)inventory.get(0);
        ItemStack bowlSlot = (ItemStack)inventory.get(7);
        int nonEmpty = 0;
        for (Object st : craftingSlots) {
            if (st.isEmpty()) continue;
            ++nonEmpty;
        }
        if (nonEmpty != this.craftingIngredients.size()) {
            return false;
        }
        HashMap<Ingredient, Integer> needed = new HashMap<Ingredient, Integer>();
        for (Ingredient ing : this.craftingIngredients) {
            needed.merge(ing, 1, Integer::sum);
        }
        for (ItemStack st : craftingSlots) {
            if (st.isEmpty()) continue;
            boolean matched = false;
            for (Map.Entry entry : needed.entrySet()) {
                if ((Integer)entry.getValue() <= 0 || !((Ingredient)entry.getKey()).test(st)) continue;
                entry.setValue((Integer)entry.getValue() - 1);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        if (!needed.values().stream().allMatch(v -> v <= 0)) {
            return false;
        }
        if (!this.bottleIngredient.isEmpty() && !this.bottleIngredient.test(bottleSlot)) {
            return false;
        }
        if (this.bottleIngredient.isEmpty() && !bottleSlot.isEmpty()) {
            return false;
        }
        if (!this.bowlIngredient.isEmpty() && !this.bowlIngredient.test(bowlSlot)) {
            return false;
        }
        if (this.bowlIngredient.isEmpty() && !bowlSlot.isEmpty()) {
            return false;
        }
        if (!this.bowlIngredient.isEmpty()) {
            int required = this.getOutputCount();
            if (bowlSlot.getCount() < required) {
                return false;
            }
        }
        return true;
    }

    public boolean matches(OvenRecipeInput input, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.matchesIngredients(input.items());
    }

    public ItemStack assemble(OvenRecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Items.FURNACE);
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ConcoctionModRecipes.OVEN_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ConcoctionModRecipes.OVEN_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<OvenRecipe> {
        public static final MapCodec<OvenRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("cooking_time").orElse((Object)200).forGetter(OvenRecipe::getCookingTime), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("crafting_ingredients").forGetter(OvenRecipe::getCraftingIngredients), (App)Ingredient.CODEC.optionalFieldOf("bottle_ingredient", (Object)Ingredient.EMPTY).forGetter(OvenRecipe::getBottleIngredient), (App)Ingredient.CODEC.optionalFieldOf("bowl_ingredient", (Object)Ingredient.EMPTY).forGetter(OvenRecipe::getBowlIngredient), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("result").forGetter(OvenRecipe::getResult)).apply((Applicative)inst, OvenRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, OvenRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, OvenRecipe::getCookingTime, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), OvenRecipe::getCraftingIngredients, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, OvenRecipe::getBottleIngredient, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, OvenRecipe::getBowlIngredient, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8), OvenRecipe::getResult, OvenRecipe::new);

        public MapCodec<OvenRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, OvenRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

