/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.system;

import net.mcreator.concoction.init.ConcoctionModDataComponents;
import net.mcreator.concoction.item.food.types.FoodEffectComponent;
import net.mcreator.concoction.item.food.types.FoodEffectType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

@EventBusSubscriber(modid="concoction", bus=EventBusSubscriber.Bus.GAME)
public class FoodTasteApplier {
    @SubscribeEvent
    public static void onFinishUse(LivingEntityUseItemEvent.Finish event) {
        ItemStack eaten = event.getItem();
        if (eaten.isEmpty()) {
            return;
        }
        LivingEntity eater = event.getEntity();
        if (eaten.getFoodProperties(eater) == null) {
            return;
        }
        FoodTasteApplier.applyTaste(eater, (FoodEffectComponent)eaten.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT.value()));
        FoodTasteApplier.applyTaste(eater, (FoodEffectComponent)eaten.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_2.value()));
        FoodTasteApplier.applyTaste(eater, (FoodEffectComponent)eaten.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_3.value()));
        FoodTasteApplier.applyTaste(eater, (FoodEffectComponent)eaten.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_4.value()));
        FoodTasteApplier.applyTaste(eater, (FoodEffectComponent)eaten.get((DataComponentType)ConcoctionModDataComponents.FOOD_EFFECT_5.value()));
    }

    private static void applyTaste(LivingEntity entity, FoodEffectComponent comp) {
        if (comp == null) {
            return;
        }
        if (comp.type() == FoodEffectType.HEAL) {
            FoodEffectType.applyInstantEffect(comp.type(), entity, comp.level());
            return;
        }
        MobEffectInstance inst = FoodEffectType.getEffect(comp.type(), comp.level(), comp.duration(), comp.isHidden(), entity);
        if (inst != null) {
            entity.addEffect(inst);
        }
    }
}

