/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.concoction.block.entity.OvenBlockEntity;
import net.mcreator.concoction.init.ConcoctionModMenus;
import net.mcreator.concoction.init.ConcoctionModSounds;
import net.mcreator.concoction.utils.Utils;
import net.mcreator.concoction.world.inventory.OvenBottleSlot;
import net.mcreator.concoction.world.inventory.OvenBowlSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class OvenGUIMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private BlockPos pos;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;
    private int progress = 0;
    private int maxProgress = 200;
    private boolean isCooking = false;
    private boolean isLit = false;

    public OvenGUIMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)ConcoctionModMenus.OVEN_GUI.get(), id);
        BlockEntity blockEntity;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.pos = null;
        if (extraData != null) {
            this.pos = extraData.readBlockPos();
            this.x = this.pos.getX();
            this.y = this.pos.getY();
            this.z = this.pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)this.pos);
            this.world.playLocalSound((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, (SoundEvent)ConcoctionModSounds.OVEN_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if ((blockEntity = this.world.getBlockEntity(this.pos)) instanceof OvenBlockEntity) {
            final OvenBlockEntity blockEntity2 = (OvenBlockEntity)blockEntity;
            this.boundBlockEntity = blockEntity2;
            this.bound = true;
            this.internal = new ItemStackHandler(this, 9){

                public ItemStack getStackInSlot(int slot) {
                    return blockEntity2.getItem(slot);
                }

                public void setStackInSlot(int slot, ItemStack stack) {
                    blockEntity2.setItem(slot, stack);
                }

                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (!simulate) {
                        blockEntity2.setItem(slot, stack);
                    }
                    return ItemStack.EMPTY;
                }

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    ItemStack existing = blockEntity2.getItem(slot);
                    if (existing.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                    ItemStack extracted = existing.copy();
                    extracted.setCount(Math.min(amount, existing.getCount()));
                    if (!simulate) {
                        existing.shrink(amount);
                        if (existing.isEmpty()) {
                            blockEntity2.setItem(slot, ItemStack.EMPTY);
                        }
                    }
                    return extracted;
                }
            };
        } else {
            this.internal = new ItemStackHandler(9);
        }
        this.addPlayerHotbar(inv);
        this.addPlayerInventory(inv);
        this.customSlots.put(36, this.addSlot((Slot)new OvenBottleSlot(this.internal, 0, 19, 33)));
        this.customSlots.put(37, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 41, 24)));
        this.customSlots.put(38, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 59, 24)));
        this.customSlots.put(39, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 77, 24)));
        this.customSlots.put(40, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 41, 42)));
        this.customSlots.put(41, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 59, 42)));
        this.customSlots.put(42, this.addSlot((Slot)new SlotItemHandler(this.internal, 6, 77, 42)));
        this.customSlots.put(43, this.addSlot((Slot)new OvenBowlSlot(this.internal, 7, 104, 13)));
        this.customSlots.put(44, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 8, 139, 34){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                if (!player.level().isClientSide() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Utils.addAchievement(serverPlayer, "concoction:oven_cooking");
                }
            }
        }));
    }

    public int getProgress() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof OvenBlockEntity) {
            OvenBlockEntity entity = (OvenBlockEntity)blockEntity;
            return entity.getProgress();
        }
        return this.progress;
    }

    public int getMaxProgress() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof OvenBlockEntity) {
            OvenBlockEntity entity = (OvenBlockEntity)blockEntity;
            return entity.getMaxProgress();
        }
        return this.maxProgress;
    }

    public boolean isCooking() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof OvenBlockEntity) {
            OvenBlockEntity entity = (OvenBlockEntity)blockEntity;
            return entity.isCooking();
        }
        return this.isCooking;
    }

    public boolean isLit() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof OvenBlockEntity) {
            OvenBlockEntity entity = (OvenBlockEntity)blockEntity;
            return entity.isLit();
        }
        return this.isLit;
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= 36 && index <= 44) {
                if (!this.moveItemStackTo(itemstack1, 9, 36, false) && !this.moveItemStackTo(itemstack1, 0, 9, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index >= 0 && index < 36) {
                boolean moved = false;
                if (itemstack1.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tableware"))) && this.moveItemStackTo(itemstack1, 43, 44, false)) {
                    moved = true;
                }
                if (!moved) {
                    if (this.moveItemStackTo(itemstack1, 36, 37, false)) {
                        moved = true;
                    } else if (this.moveItemStackTo(itemstack1, 37, 43, false)) {
                        moved = true;
                    }
                }
                if (!moved) {
                    return ItemStack.EMPTY;
                }
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.pos != null) {
            this.world.playLocalSound((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, (SoundEvent)ConcoctionModSounds.OVEN_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }
}

