/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.worldgen;

import com.mojang.serialization.Codec;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import net.mcreator.concoction.worldgen.SaponariaPatchConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SaponariaPatchFeature
extends Feature<SaponariaPatchConfig> {
    public SaponariaPatchFeature(Codec<SaponariaPatchConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SaponariaPatchConfig> ctx) {
        WorldGenLevel level = ctx.level();
        RandomSource rand = ctx.random();
        BlockPos origin = ctx.origin();
        SaponariaPatchConfig cfg = (SaponariaPatchConfig)ctx.config();
        Registry blockRegistry = level.registryAccess().registryOrThrow(Registries.BLOCK);
        Block saponaria = (Block)blockRegistry.getOptional(cfg.block()).orElseThrow();
        BlockPos start = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, origin);
        if ((start = SaponariaPatchFeature.findFirstSolidBelow((LevelReader)level, start)) == null) {
            return false;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayList<BlockPos> placedCenters = new ArrayList<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        visited.add(start);
        int radius = Math.max(1, cfg.radius());
        int tries = Math.max(radius * 2, cfg.spreadTries());
        while (!queue.isEmpty() && tries-- > 0) {
            BlockPos cur = (BlockPos)queue.poll();
            boolean placedAny = this.tryAttachAround((LevelAccessor)level, rand, cur, saponaria, cfg.attemptsPerPos());
            if (placedAny) {
                placedCenters.add(cur);
            }
            for (Direction d : Direction.values()) {
                BlockPos np = cur.relative(d);
                if (!visited.add(np) || SaponariaPatchFeature.manhattan(np, start) > radius) continue;
                queue.add(np);
            }
        }
        if (placedCenters.isEmpty()) {
            return false;
        }
        BlockPos center = start;
        int maxD = placedCenters.stream().mapToInt(p -> SaponariaPatchFeature.manhattan(p, center)).max().orElse(1);
        BlockPos min = start.offset(-radius, -1, -radius);
        BlockPos max = start.offset(radius, 1, radius);
        IntegerProperty ageProp = SaponariaPatchFeature.findIntProp(saponaria.defaultBlockState(), "age");
        IntegerProperty vigorProp = SaponariaPatchFeature.findIntProp(saponaria.defaultBlockState(), "vigor");
        for (BlockPos p2 : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            BlockState st = level.getBlockState(p2);
            if (!st.is(saponaria)) continue;
            int d = Math.min(maxD, SaponariaPatchFeature.manhattan(p2, start));
            double t = maxD == 0 ? 0.0 : (double)d / (double)maxD;
            int val = SaponariaPatchFeature.clamp(Math.round((float)((1.0 - t) * 2.0)), 0, 2);
            if (ageProp != null && st.hasProperty((Property)ageProp)) {
                st = (BlockState)st.setValue((Property)ageProp, (Comparable)Integer.valueOf(val));
            }
            if (vigorProp != null && st.hasProperty((Property)vigorProp)) {
                st = (BlockState)st.setValue((Property)vigorProp, (Comparable)Integer.valueOf(val));
            }
            level.setBlock(p2, st, 2);
        }
        return true;
    }

    private static BlockPos findFirstSolidBelow(LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos m = pos.mutable();
        for (int i = 0; i < 16; ++i) {
            BlockState below = level.getBlockState(m.below());
            if (!below.isAir()) {
                return m.immutable();
            }
            m.move(0, -1, 0);
        }
        return null;
    }

    private boolean tryAttachAround(LevelAccessor level, RandomSource rand, BlockPos center, Block saponaria, int attempts) {
        boolean placed = false;
        for (int i = 0; i < attempts; ++i) {
            BlockState state;
            BlockPos p = center.offset(rand.nextInt(3) - 1, rand.nextInt(3) - 1, rand.nextInt(3) - 1);
            if (!SaponariaPatchFeature.canReplace(level, p) || (state = this.makeAttachedState(level, p, saponaria)) == null) continue;
            level.setBlock(p, state, 2);
            placed = true;
        }
        return placed;
    }

    private static boolean canReplace(LevelAccessor level, BlockPos pos) {
        BlockState st = level.getBlockState(pos);
        return st.isAir();
    }

    private BlockState makeAttachedState(LevelAccessor level, BlockPos pos, Block saponaria) {
        BlockState base = saponaria.defaultBlockState();
        StateDefinition def = base.getBlock().getStateDefinition();
        EnumMap<Direction, BooleanProperty> dirProps = new EnumMap<Direction, BooleanProperty>(Direction.class);
        dirProps.put(Direction.UP, SaponariaPatchFeature.findBoolProp((StateDefinition<Block, BlockState>)def, "up"));
        dirProps.put(Direction.DOWN, SaponariaPatchFeature.findBoolProp((StateDefinition<Block, BlockState>)def, "down"));
        dirProps.put(Direction.NORTH, SaponariaPatchFeature.findBoolProp((StateDefinition<Block, BlockState>)def, "north"));
        dirProps.put(Direction.SOUTH, SaponariaPatchFeature.findBoolProp((StateDefinition<Block, BlockState>)def, "south"));
        dirProps.put(Direction.EAST, SaponariaPatchFeature.findBoolProp((StateDefinition<Block, BlockState>)def, "east"));
        dirProps.put(Direction.WEST, SaponariaPatchFeature.findBoolProp((StateDefinition<Block, BlockState>)def, "west"));
        boolean any = false;
        BlockState st = base;
        for (Direction d : Direction.values()) {
            BooleanProperty prop;
            BlockPos neighbor = pos.relative(d);
            BlockState nb = level.getBlockState(neighbor);
            if (!nb.isFaceSturdy((BlockGetter)level, neighbor, d.getOpposite()) || (prop = (BooleanProperty)dirProps.get(d)) == null || !st.hasProperty((Property)prop)) continue;
            st = (BlockState)st.setValue((Property)prop, (Comparable)Boolean.valueOf(true));
            any = true;
        }
        return any ? st : null;
    }

    private static IntegerProperty findIntProp(BlockState sample, String name) {
        for (Property p : sample.getProperties()) {
            if (!(p instanceof IntegerProperty)) continue;
            IntegerProperty ip = (IntegerProperty)p;
            if (!p.getName().equalsIgnoreCase(name) || !ip.getPossibleValues().containsAll(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))) continue;
            return ip;
        }
        return null;
    }

    private static BooleanProperty findBoolProp(StateDefinition<Block, BlockState> def, String name) {
        for (Property p : def.getProperties()) {
            if (!(p instanceof BooleanProperty)) continue;
            BooleanProperty bp = (BooleanProperty)p;
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return bp;
        }
        return null;
    }

    private static int manhattan(BlockPos a, BlockPos b) {
        return Math.abs(a.getX() - b.getX()) + Math.abs(a.getY() - b.getY()) + Math.abs(a.getZ() - b.getZ());
    }

    private static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }
}

