/*
 * Decompiled with CFR 0.152.
 */
package del.mod.dlib.events;

import del.mod.dlib.events.DEvent;
import del.mod.dlib.events.DSubscribeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DEventManager {
    private static final Map<Class<?>, List<ListenerData>> listeners = new ConcurrentHashMap();

    private DEventManager() {
    }

    public static void register(Object listenerOwner) {
        for (Method method : listenerOwner.getClass().getDeclaredMethods()) {
            Class<?>[] params;
            if (!method.isAnnotationPresent(DSubscribeEvent.class) || (params = method.getParameterTypes()).length != 1 || !DEvent.class.isAssignableFrom(params[0])) continue;
            method.setAccessible(true);
            int priority = method.getAnnotation(DSubscribeEvent.class).priority();
            Class<?> eventType = params[0];
            listeners.computeIfAbsent(eventType, k -> new ArrayList()).add(new ListenerData(listenerOwner, method, priority));
            listeners.get(eventType).sort((a, b) -> Integer.compare(b.priority, a.priority));
        }
    }

    public static void unregister(Object listenerOwner) {
        for (List<ListenerData> list : listeners.values()) {
            list.removeIf(ld -> ld.owner == listenerOwner);
        }
        listeners.entrySet().removeIf(e -> ((List)e.getValue()).isEmpty());
    }

    public static void post(DEvent event) {
        List<ListenerData> list = listeners.get(event.getClass());
        if (list == null) {
            return;
        }
        for (ListenerData ld : list) {
            if (event.isCanceled()) break;
            try {
                ld.method.invoke(ld.owner, event);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ListenerData {
        final Object owner;
        final Method method;
        final int priority;

        ListenerData(Object owner, Method method, int priority) {
            this.owner = owner;
            this.method = method;
            this.priority = priority;
        }
    }
}

