/*
 * Decompiled with CFR 0.152.
 */
package del.mod.dlib.fgevents;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import del.mod.dlib.DLib;
import del.mod.dlib.events.DEventManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DLibEventsMod {
    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        DLib.LOGGER.info("Starting mod search");
        for (IModFileInfo modFile : ModList.get().getModFiles()) {
            DLib.LOGGER.info("Mod Search for mod ids: {}", (Object)modFile.getMods().stream().map(IModInfo::getModId).collect(Collectors.joining(", ")));
            Path modPath = modFile.getFile().getFilePath();
            try {
                if (Files.isDirectory(modPath, new LinkOption[0])) {
                    Path events = modPath.resolve("dlib/events.json");
                    if (!Files.exists(events, new LinkOption[0])) continue;
                    DLib.LOGGER.info("Mod Search (dir) found events.json data");
                    DLibEventsMod.processEventsData(Files.readString(events));
                    continue;
                }
                if (!modPath.toString().endsWith(".jar")) continue;
                try (JarFile jar = new JarFile(modPath.toFile());){
                    ZipEntry entry = jar.getEntry("dlib/events.json");
                    if (entry == null) continue;
                    DLib.LOGGER.info("Mod Search (jar) found events.json data");
                    InputStream is = jar.getInputStream(entry);
                    try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                         BufferedReader reader = new BufferedReader(isr);){
                        String line;
                        StringBuilder content = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            content.append(line).append("\n");
                        }
                        DLibEventsMod.processEventsData(content.toString());
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    DLib.LOGGER.info("Mod Search (jar) found events.json data error");
                }
            }
            catch (Exception e) {
                DLib.LOGGER.error("Error in Mod Search: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void processEventsData(String fileStr) {
        try {
            JsonObject json = JsonParser.parseString((String)fileStr).getAsJsonObject();
            JsonArray classes = json.getAsJsonArray("classes");
            ArrayList<String> classesList = new ArrayList<String>();
            for (int i = 0; i < classes.size(); ++i) {
                String value = classes.get(i).getAsString();
                classesList.add(value);
            }
            ArrayList listenerInstances = new ArrayList();
            for (String className : classesList) {
                Class<?> clazz = Class.forName(className);
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                listenerInstances.add(instance);
                DEventManager.register(instance);
            }
        }
        catch (Exception e) {
            DLib.LOGGER.error("Mod Search.Events error{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

