/*
 * Decompiled with CFR 0.152.
 */
package del.mod.dlib.mixins;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import del.mod.dlib.events.DEventManager;
import del.mod.dlib.events.eventl.BiomeHasPrecipitationEvent;
import del.mod.dlib.events.eventl.BiomePrecipitationEvent;
import del.mod.dlib.events.eventl.CloudsTextureModifyEvent;
import del.mod.dlib.events.eventl.EndSkyTextureModifyEvent;
import del.mod.dlib.events.eventl.MoonTextureModifyEvent;
import del.mod.dlib.events.eventl.RainTextureModifyEvent;
import del.mod.dlib.events.eventl.SnowTextureModifyEvent;
import del.mod.dlib.events.eventl.SunTextureModifyEvent;
import del.mod.dlib.events.eventl.WorldBorderTextureModifyEvent;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private static ResourceLocation f_109458_;
    @Shadow
    @Final
    private static ResourceLocation f_109455_;
    @Shadow
    @Final
    private static ResourceLocation f_109454_;
    @Shadow
    @Final
    private static ResourceLocation f_109456_;
    @Shadow
    @Final
    private static ResourceLocation f_109457_;
    @Shadow
    @Final
    private static ResourceLocation f_109459_;
    @Shadow
    @Final
    private static ResourceLocation f_109460_;

    @Redirect(method={"renderSnowAndRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;hasPrecipitation()Z"))
    private boolean hasPrecipitation(Biome biome) {
        BiomeHasPrecipitationEvent event = new BiomeHasPrecipitationEvent(biome, biome.m_264473_());
        DEventManager.post(event);
        return event.precipitation;
    }

    @Redirect(method={"renderSnowAndRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;"))
    private Biome.Precipitation getPrecipitationAt(Biome biome, BlockPos blockPos) {
        BiomePrecipitationEvent event = new BiomePrecipitationEvent(biome, blockPos, biome.m_264600_(blockPos));
        DEventManager.post(event);
        return event.precipitation;
    }

    @Redirect(method={"renderSky"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;SUN_LOCATION:Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation sunTexture() {
        SunTextureModifyEvent event = new SunTextureModifyEvent(f_109455_);
        DEventManager.post(event);
        return event.resourceLocation;
    }

    @Redirect(method={"renderSky"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;MOON_LOCATION:Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation moonTexture() {
        MoonTextureModifyEvent event = new MoonTextureModifyEvent(f_109454_);
        DEventManager.post(event);
        return event.resourceLocation;
    }

    @Redirect(method={"renderClouds"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;CLOUDS_LOCATION:Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation cloudsTexture() {
        CloudsTextureModifyEvent event = new CloudsTextureModifyEvent(f_109456_);
        DEventManager.post(event);
        return event.resourceLocation;
    }

    @Redirect(method={"renderEndSky"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;END_SKY_LOCATION:Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation endSkyTexture() {
        EndSkyTextureModifyEvent event = new EndSkyTextureModifyEvent(f_109457_);
        DEventManager.post(event);
        return event.resourceLocation;
    }

    @Redirect(method={"renderWorldBorder"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;FORCEFIELD_LOCATION:Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation forcefieldTexture() {
        WorldBorderTextureModifyEvent event = new WorldBorderTextureModifyEvent(f_109458_);
        DEventManager.post(event);
        return event.resourceLocation;
    }

    @Redirect(method={"renderSnowAndRain"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;RAIN_LOCATION:Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation rainTexture() {
        RainTextureModifyEvent event = new RainTextureModifyEvent(f_109459_);
        DEventManager.post(event);
        return event.resourceLocation;
    }

    @Redirect(method={"renderSnowAndRain"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;SNOW_LOCATION:Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation snowTexture() {
        SnowTextureModifyEvent event = new SnowTextureModifyEvent(f_109460_);
        DEventManager.post(event);
        return event.resourceLocation;
    }

    @Inject(method={"drawStars"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawStarsVertex(BufferBuilder pBuilder, CallbackInfoReturnable<BufferBuilder.RenderedBuffer> cir) {
        RandomSource randomsource = RandomSource.m_216335_((long)10842L);
        pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double dirX = randomsource.m_188501_() * 2.0f - 1.0f;
            double dirY = randomsource.m_188501_() * 2.0f - 1.0f;
            double dirZ = randomsource.m_188501_() * 2.0f - 1.0f;
            double quadHalfSize = 0.15f + randomsource.m_188501_() * 0.1f;
            double lengthSq = dirX * dirX + dirY * dirY + dirZ * dirZ;
            if (!(lengthSq < 1.0) || !(lengthSq > 0.01)) continue;
            lengthSq = 1.0 / Math.sqrt(lengthSq);
            double posX = (dirX *= lengthSq) * 100.0;
            double posY = (dirY *= lengthSq) * 100.0;
            double posZ = (dirZ *= lengthSq) * 100.0;
            double angleXZ = Math.atan2(dirX, dirZ);
            double sinXZ = Math.sin(angleXZ);
            double cosXZ = Math.cos(angleXZ);
            double angleY = Math.atan2(Math.sqrt(dirX * dirX + dirZ * dirZ), dirY);
            double sinY = Math.sin(angleY);
            double cosY = Math.cos(angleY);
            double rotationAngle = randomsource.m_188500_() * Math.PI * 2.0;
            double sinRot = Math.sin(rotationAngle);
            double cosRot = Math.cos(rotationAngle);
            for (int j = 0; j < 4; ++j) {
                double offsetX = (double)((j & 2) - 1) * quadHalfSize;
                double offsetY = (double)((j + 1 & 2) - 1) * quadHalfSize;
                double rotatedX = offsetX * cosRot - offsetY * sinRot;
                double rotatedY = offsetY * cosRot + offsetX * sinRot;
                double finalY = rotatedX * sinY + 0.0 * cosY;
                double finalQ = 0.0 * sinY - rotatedX * cosY;
                double finalX = finalQ * sinXZ - rotatedY * cosXZ;
                double finalZ = rotatedY * sinXZ + finalQ * cosXZ;
                pBuilder.m_5483_(posX + finalX, posY + finalY, posZ + finalZ).m_5752_();
            }
        }
        cir.setReturnValue((Object)pBuilder.m_231175_());
    }
}

