/*
 * Decompiled with CFR 0.152.
 */
package del.mod.dlib.ren;

import del.mod.dlib.ren.Renders;
import del.mod.dlib.types.DColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class RenderOptions {
    public boolean renderFrontFaces = true;
    public boolean renderBackFaces = true;
    public boolean useMultiColor = false;
    public DColor[] colors;
    public DColor color;
    public Vec3 offset = new Vec3(0.0, 0.0, 0.0);
    public Vec3 rotationDegrees = new Vec3(0.0, 0.0, 0.0);
    public Vec3 scale = new Vec3(1.0, 1.0, 1.0);
    public Vec3 pivot = new Vec3(0.0, 0.0, 0.0);
    public ResourceLocation texture;
    public int verticalStripes;
    public int horizontalStripes;
    public float radius;
    public float height;
    public int segments;
    public float minorRadius;

    public RenderOptions withUseMultiColor(boolean v) {
        this.useMultiColor = v;
        return this;
    }

    public RenderOptions withColors(DColor[] v) {
        this.colors = v;
        return this;
    }

    public RenderOptions withColors(DColor a, DColor b, DColor c) {
        this.colors = new DColor[]{a, b, c};
        return this;
    }

    public RenderOptions withColor(DColor v) {
        this.color = v;
        return this;
    }

    public RenderOptions withRenderFrontFaces(boolean v) {
        this.renderFrontFaces = v;
        return this;
    }

    public RenderOptions withRenderBackFaces(boolean v) {
        this.renderBackFaces = v;
        return this;
    }

    public RenderOptions withOffset(Vec3 v) {
        this.offset = v;
        return this;
    }

    public RenderOptions withOffset(double x, double y, double z) {
        this.offset = new Vec3(x, y, z);
        return this;
    }

    public RenderOptions withRotationDegrees(float rx, float ry, float rz) {
        this.rotationDegrees = new Vec3((double)rx, (double)ry, (double)rz);
        return this;
    }

    public RenderOptions withRotationDegrees(Vec3 v) {
        this.rotationDegrees = v;
        return this;
    }

    public RenderOptions withScale(float s) {
        this.scale = new Vec3((double)s, (double)s, (double)s);
        return this;
    }

    public RenderOptions withScale(Vec3 s) {
        this.scale = s;
        return this;
    }

    public RenderOptions withPivot(Vec3 s) {
        this.pivot = s;
        return this;
    }

    public RenderOptions withPivot(double x, double y, double z) {
        this.pivot = new Vec3(x, y, z);
        return this;
    }

    public RenderOptions withPivot(float x, float y, float z) {
        this.pivot = new Vec3((double)x, (double)y, (double)z);
        return this;
    }

    public RenderOptions withTexture(ResourceLocation tex) {
        this.texture = tex;
        return this;
    }

    public RenderOptions withVerticalStripes(int count) {
        this.verticalStripes = count;
        return this;
    }

    public RenderOptions withHorizontalStripes(int count) {
        this.horizontalStripes = count;
        return this;
    }

    public RenderOptions withSegments(int count) {
        this.segments = count;
        return this;
    }

    public RenderOptions withRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public RenderOptions withMinorRadius(float minorRadius) {
        this.minorRadius = minorRadius;
        return this;
    }

    public RenderOptions withHeight(float height) {
        this.height = height;
        return this;
    }

    public RenderOptions withColorsSphere(String pattern, long seed, DColor ... baseColors) {
        this.colors = Renders.generateColorListSphere(baseColors, pattern, this, seed);
        this.useMultiColor = true;
        return this;
    }

    public RenderOptions withColorsCylinderGradient6(DColor ... baseColors) {
        this.colors = Renders.generateCylinderColors(baseColors, this);
        this.useMultiColor = true;
        return this;
    }

    public RenderOptions withColorsCylinderGradient4(DColor ... baseColors) {
        if (baseColors == null || baseColors.length != 4) {
            throw new IllegalArgumentException("withColorsCylinderGradient4 - baseColors must have exactly 4 colors: bottom center, bottom edges + side bottom, side top + top edges, top center");
        }
        this.colors = Renders.generateCylinderColors(new DColor[]{baseColors[0], baseColors[1], baseColors[1], baseColors[2], baseColors[2], baseColors[3]}, this);
        this.useMultiColor = true;
        return this;
    }
}

