/*
 * Decompiled with CFR 0.152.
 */
package del.mod.dlib.ren;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import del.mod.dlib.ren.RenderOptions;
import del.mod.dlib.types.DColor;
import java.util.Random;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Renders {
    public static boolean ignoreWarningExceptions = false;

    public static Matrix4f createTransformMatrix(Vector3f offset, Vector3f rotation, Vector3f scale, Vector3f pivot) {
        return new Matrix4f().identity().translate((Vector3fc)offset).translate((Vector3fc)pivot).rotateX((float)Math.toRadians(rotation.x)).rotateY((float)Math.toRadians(rotation.y)).rotateZ((float)Math.toRadians(rotation.z)).scale((Vector3fc)scale).translate((Vector3fc)new Vector3f((Vector3fc)pivot).negate());
    }

    public static Matrix4f createTransformMatrix(Vec3 offset, Vec3 rotation, Vec3 scale, Vec3 pivot) {
        return new Matrix4f().identity().translate((Vector3fc)offset.m_252839_()).translate((Vector3fc)pivot.m_252839_()).rotateX((float)Math.toRadians(rotation.f_82479_)).rotateY((float)Math.toRadians(rotation.f_82480_)).rotateZ((float)Math.toRadians(rotation.f_82481_)).scale((Vector3fc)scale.m_252839_()).translate((Vector3fc)new Vector3f((Vector3fc)pivot.m_252839_()).negate());
    }

    public static Vec3 getSmoothedPlayerPos(LocalPlayer player, float partialTicks) {
        double x = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)partialTicks;
        double y = player.f_19791_ + (player.m_20186_() - player.f_19791_) * (double)partialTicks;
        double z = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)partialTicks;
        return new Vec3(x, y, z);
    }

    public static double estimateSmoothedEyeHeight(LocalPlayer player, float partialTicks) {
        double eyeHeightNew = player.m_20192_();
        double eyeHeightOldApprox = eyeHeightNew - (player.m_20186_() - player.f_19791_);
        return eyeHeightOldApprox + (eyeHeightNew - eyeHeightOldApprox) * (double)partialTicks;
    }

    public static Vec3 getSmoothedPlayerEyePos(LocalPlayer player, float partialTicks) {
        double x = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)partialTicks;
        double y = player.f_19791_ + (player.m_20186_() - player.f_19791_) * (double)partialTicks + Renders.estimateSmoothedEyeHeight(player, partialTicks);
        double z = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)partialTicks;
        return new Vec3(x, y, z);
    }

    public static Vec3 getSmoothedPos(Vec3 oldPos, Vec3 newPos, float partialTicks) {
        double x = oldPos.f_82479_ + (newPos.f_82479_ - oldPos.f_82479_) * (double)partialTicks;
        double y = oldPos.f_82480_ + (newPos.f_82480_ - oldPos.f_82480_) * (double)partialTicks;
        double z = oldPos.f_82481_ + (newPos.f_82481_ - oldPos.f_82481_) * (double)partialTicks;
        return new Vec3(x, y, z);
    }

    public static DColor[] generateColorListSphere(DColor[] baseColors, String pattern, RenderOptions options, long seed) {
        if (baseColors == null || baseColors.length == 0) {
            throw new IllegalArgumentException("Base colors array cannot be empty");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        pattern = pattern.toLowerCase();
        boolean vertical = pattern.contains("vertical");
        boolean horizontal = pattern.contains("horizontal");
        boolean diagonal = pattern.equals("diagonal");
        boolean diagonalInv = pattern.equals("diagonal_inv");
        boolean randomPattern = pattern.contains("random");
        if (!(vertical || horizontal || diagonal || diagonalInv || randomPattern)) {
            vertical = true;
        }
        int facesCount = 0;
        if (options.renderFrontFaces) {
            facesCount += 6;
        }
        if (options.renderBackFaces) {
            facesCount += 6;
        }
        if (facesCount == 0) {
            return new DColor[0];
        }
        int hStripes = options.horizontalStripes;
        int vStripes = options.verticalStripes;
        DColor[] colors = new DColor[hStripes * vStripes * facesCount];
        int idx = 0;
        Random rand = null;
        if (randomPattern) {
            rand = new Random(seed);
        }
        for (int lat = 0; lat < hStripes; ++lat) {
            for (int lon = 0; lon < vStripes; ++lon) {
                DColor color;
                if (randomPattern) {
                    color = baseColors[rand.nextInt(baseColors.length)];
                } else if (vertical) {
                    color = baseColors[lon % baseColors.length];
                } else if (horizontal) {
                    color = baseColors[lat % baseColors.length];
                } else if (diagonal) {
                    diagIndex = (lat + lon) % baseColors.length;
                    color = baseColors[diagIndex];
                } else if (diagonalInv) {
                    diagIndex = Math.floorMod(lat - lon, baseColors.length);
                    color = baseColors[diagIndex];
                } else {
                    color = baseColors[lon % baseColors.length];
                }
                for (int i = 0; i < facesCount; ++i) {
                    colors[idx++] = color;
                }
            }
        }
        return colors;
    }

    public static DColor[] generateCylinderColors(DColor[] baseColors, RenderOptions options) {
        int next;
        int i;
        if (baseColors == null || baseColors.length != 6) {
            throw new IllegalArgumentException("baseColors must have exactly 6 colors: bottom center, bottom edges, side bottom, side top, top edges, top center");
        }
        if (options.segments < 3) {
            throw new IllegalArgumentException("Cylinder must have at least 3 segments");
        }
        int segments = options.segments;
        int facesCount = 0;
        if (options.renderFrontFaces) {
            ++facesCount;
        }
        if (options.renderBackFaces) {
            ++facesCount;
        }
        int totalVertices = segments * 24 * facesCount;
        DColor[] colors = new DColor[totalVertices];
        DColor bottomCenter = baseColors[0];
        DColor bottomEdges = baseColors[1];
        DColor sideBottom = baseColors[2];
        DColor sideTop = baseColors[3];
        DColor topEdges = baseColors[4];
        DColor topCenter = baseColors[5];
        int colorIndex = 0;
        for (i = 0; i < options.segments; ++i) {
            DColor c;
            next = (i + 1) % options.segments;
            if (options.renderFrontFaces) {
                if (!options.useMultiColor) {
                    c = baseColors[2];
                    colors[colorIndex++] = sideBottom;
                    colors[colorIndex++] = sideTop;
                    colors[colorIndex++] = sideTop;
                    colors[colorIndex++] = sideBottom;
                    colors[colorIndex++] = sideTop;
                    colors[colorIndex++] = sideBottom;
                } else {
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                }
            }
            if (!options.renderBackFaces) continue;
            if (!options.useMultiColor) {
                c = baseColors[2];
                colors[colorIndex++] = sideBottom;
                colors[colorIndex++] = sideTop;
                colors[colorIndex++] = sideTop;
                colors[colorIndex++] = sideBottom;
                colors[colorIndex++] = sideBottom;
                colors[colorIndex++] = sideTop;
                continue;
            }
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
        }
        for (i = 0; i < options.segments; ++i) {
            next = (i + 1) % options.segments;
            if (options.renderFrontFaces) {
                if (!options.useMultiColor) {
                    colors[colorIndex++] = topCenter;
                    colors[colorIndex++] = topEdges;
                    colors[colorIndex++] = topEdges;
                } else {
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                }
            }
            if (!options.renderBackFaces) continue;
            if (!options.useMultiColor) {
                colors[colorIndex++] = topCenter;
                colors[colorIndex++] = topEdges;
                colors[colorIndex++] = topEdges;
                continue;
            }
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
        }
        for (i = 0; i < options.segments; ++i) {
            next = (i + 1) % options.segments;
            if (options.renderFrontFaces) {
                if (!options.useMultiColor) {
                    colors[colorIndex++] = bottomCenter;
                    colors[colorIndex++] = bottomEdges;
                    colors[colorIndex++] = bottomEdges;
                } else {
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                    colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
                }
            }
            if (!options.renderBackFaces) continue;
            if (!options.useMultiColor) {
                colors[colorIndex++] = bottomCenter;
                colors[colorIndex++] = bottomEdges;
                colors[colorIndex++] = bottomEdges;
                continue;
            }
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
            colors[colorIndex++] = baseColors[colorIndex % baseColors.length];
        }
        return colors;
    }

    public static void renderTriangleColor(Matrix4f baseMat, Vec3 v1, Vec3 v2, Vec3 v3, RenderOptions options) {
        DColor c2;
        DColor c1;
        DColor c0;
        DColor color;
        Matrix4f mat = new Matrix4f((Matrix4fc)baseMat).mul((Matrix4fc)Renders.createTransformMatrix(options.offset, options.rotationDegrees, options.scale, options.pivot));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        if (options.renderFrontFaces) {
            if (!options.useMultiColor) {
                if (options.color == null) {
                    throw new IllegalArgumentException("renderTriangleColor requires a color");
                }
                color = options.color;
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(color.r(), color.g(), color.b(), color.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(color.r(), color.g(), color.b(), color.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(color.r(), color.g(), color.b(), color.a()).m_5752_();
            } else {
                if (options.colors.length < 3 || options.colors.length > 3 && !ignoreWarningExceptions) {
                    throw new IllegalArgumentException("renderTriangleColor must have exactly 3 colors (" + options.colors.length + " supplied)");
                }
                c0 = options.colors[0];
                c1 = options.colors[1];
                c2 = options.colors[2];
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c0.r(), c0.g(), c0.b(), c0.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c1.r(), c1.g(), c1.b(), c1.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c2.r(), c2.g(), c2.b(), c2.a()).m_5752_();
            }
        }
        if (options.renderBackFaces) {
            if (!options.useMultiColor) {
                if (options.color == null) {
                    throw new IllegalArgumentException("renderTriangleColor requires a color");
                }
                color = options.color;
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(color.r(), color.g(), color.b(), color.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(color.r(), color.g(), color.b(), color.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(color.r(), color.g(), color.b(), color.a()).m_5752_();
            } else {
                if (options.colors.length < 3 || options.colors.length > 3 && !ignoreWarningExceptions) {
                    throw new IllegalArgumentException("renderTriangleColor must have exactly 3 colors (" + options.colors.length + " supplied)");
                }
                c0 = options.colors[0];
                c1 = options.colors[1];
                c2 = options.colors[2];
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c0.r(), c0.g(), c0.b(), c0.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c2.r(), c2.g(), c2.b(), c2.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c1.r(), c1.g(), c1.b(), c1.a()).m_5752_();
            }
        }
        tess.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderQuadTexture(Matrix4f baseMat, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, RenderOptions options) {
        Matrix4f mat = new Matrix4f((Matrix4fc)baseMat).mul((Matrix4fc)Renders.createTransformMatrix(options.offset, options.rotationDegrees, options.scale, options.pivot));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)options.texture);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
        if (options.renderFrontFaces) {
            buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_7421_(0.0f, 1.0f).m_5752_();
        }
        if (options.renderBackFaces) {
            buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_7421_(1.0f, 0.0f).m_5752_();
        }
        tess.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderSphereColor(Matrix4f baseMat, Vec3 center, float radius, RenderOptions options) {
        Matrix4f mat = new Matrix4f((Matrix4fc)baseMat).mul((Matrix4fc)Renders.createTransformMatrix(options.offset, options.rotationDegrees, options.scale, options.pivot));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        DColor[] colors = null;
        int facesCount = 0;
        if (options.renderFrontFaces) {
            facesCount += 6;
        }
        if (options.renderBackFaces) {
            facesCount += 6;
        }
        int requiredColorsLength = options.horizontalStripes * options.verticalStripes * facesCount;
        if (options.useMultiColor) {
            if (options.colors == null || options.colors.length != requiredColorsLength) {
                throw new IllegalArgumentException("renderSphereColor requires colors length of " + requiredColorsLength + " (" + options.colors.length + " supplied)");
            }
            colors = options.colors;
        } else if (options.color == null) {
            throw new IllegalArgumentException("renderSphereColor requires a color if useMultiColor is false");
        }
        int colorIndex = 0;
        for (int lat = 0; lat < options.horizontalStripes; ++lat) {
            float theta1 = (float)((double)lat * Math.PI / (double)options.horizontalStripes);
            float theta2 = (float)((double)(lat + 1) * Math.PI / (double)options.horizontalStripes);
            for (int lon = 0; lon < options.verticalStripes; ++lon) {
                DColor c;
                float phi1 = (float)((double)(lon * 2) * Math.PI / (double)options.verticalStripes);
                float phi2 = (float)((double)((lon + 1) * 2) * Math.PI / (double)options.verticalStripes);
                Vec3 v1 = new Vec3(center.f_82479_ + (double)radius * Math.sin(theta1) * Math.cos(phi1), center.f_82480_ + (double)radius * Math.cos(theta1), center.f_82481_ + (double)radius * Math.sin(theta1) * Math.sin(phi1));
                Vec3 v2 = new Vec3(center.f_82479_ + (double)radius * Math.sin(theta2) * Math.cos(phi1), center.f_82480_ + (double)radius * Math.cos(theta2), center.f_82481_ + (double)radius * Math.sin(theta2) * Math.sin(phi1));
                Vec3 v3 = new Vec3(center.f_82479_ + (double)radius * Math.sin(theta2) * Math.cos(phi2), center.f_82480_ + (double)radius * Math.cos(theta2), center.f_82481_ + (double)radius * Math.sin(theta2) * Math.sin(phi2));
                Vec3 v4 = new Vec3(center.f_82479_ + (double)radius * Math.sin(theta1) * Math.cos(phi2), center.f_82480_ + (double)radius * Math.cos(theta1), center.f_82481_ + (double)radius * Math.sin(theta1) * Math.sin(phi2));
                if (options.renderFrontFaces) {
                    if (!options.useMultiColor) {
                        c = options.color;
                        buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    } else {
                        buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        ++colorIndex;
                    }
                }
                if (!options.renderBackFaces) continue;
                if (!options.useMultiColor) {
                    c = options.color;
                    buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    continue;
                }
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                ++colorIndex;
            }
        }
        tess.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderCylinderColor(Matrix4f baseMat, Vec3 center, RenderOptions options) {
        DColor c;
        int i;
        if (options.segments < 3) {
            throw new IllegalArgumentException("Cylinder must have at least 3 segments");
        }
        if (options.radius <= 0.0f) {
            throw new IllegalArgumentException("Radius must be positive");
        }
        if (options.height <= 0.0f) {
            throw new IllegalArgumentException("Height must be positive");
        }
        Matrix4f mat = new Matrix4f((Matrix4fc)baseMat).mul((Matrix4fc)Renders.createTransformMatrix(options.offset, options.rotationDegrees, options.scale, options.pivot));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        DColor[] colors = null;
        int facesCount = 0;
        if (options.renderFrontFaces) {
            ++facesCount;
        }
        if (options.renderBackFaces) {
            ++facesCount;
        }
        int requiredColorsLength = options.segments * 24 * facesCount;
        if (options.useMultiColor) {
            if (options.colors == null || options.colors.length != requiredColorsLength) {
                throw new IllegalArgumentException("renderCylinderColor requires colors length of " + requiredColorsLength + " (" + (options.colors == null ? 0 : options.colors.length) + " supplied)");
            }
            colors = options.colors;
        } else if (options.color == null) {
            throw new IllegalArgumentException("renderCylinderColor requires a color if useMultiColor is false");
        }
        int colorIndex = 0;
        Vec3 topCenter = new Vec3(center.f_82479_, center.f_82480_ + (double)(options.height / 2.0f), center.f_82481_);
        Vec3 bottomCenter = new Vec3(center.f_82479_, center.f_82480_ - (double)(options.height / 2.0f), center.f_82481_);
        Vec3[] topRing = new Vec3[options.segments];
        Vec3[] bottomRing = new Vec3[options.segments];
        for (i = 0; i < options.segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)options.segments;
            float x = (float)(center.f_82479_ + (double)(options.radius * (float)Math.cos(angle)));
            float z = (float)(center.f_82481_ + (double)(options.radius * (float)Math.sin(angle)));
            topRing[i] = new Vec3((double)x, topCenter.f_82480_, (double)z);
            bottomRing[i] = new Vec3((double)x, bottomCenter.f_82480_, (double)z);
        }
        for (i = 0; i < options.segments; ++i) {
            int next = (i + 1) % options.segments;
            if (options.renderFrontFaces) {
                if (!options.useMultiColor) {
                    c = options.color;
                    buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                } else {
                    buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    ++colorIndex;
                }
            }
            if (!options.renderBackFaces) continue;
            if (!options.useMultiColor) {
                c = options.color;
                buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                continue;
            }
            buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            ++colorIndex;
        }
        for (i = 0; i < options.segments; ++i) {
            int next = (i + 1) % options.segments;
            if (options.renderFrontFaces) {
                if (!options.useMultiColor) {
                    c = options.color;
                    buffer.m_252986_(mat, (float)topCenter.f_82479_, (float)topCenter.f_82480_, (float)topCenter.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                } else {
                    buffer.m_252986_(mat, (float)topCenter.f_82479_, (float)topCenter.f_82480_, (float)topCenter.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    ++colorIndex;
                }
            }
            if (!options.renderBackFaces) continue;
            if (!options.useMultiColor) {
                c = options.color;
                buffer.m_252986_(mat, (float)topCenter.f_82479_, (float)topCenter.f_82480_, (float)topCenter.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                continue;
            }
            buffer.m_252986_(mat, (float)topCenter.f_82479_, (float)topCenter.f_82480_, (float)topCenter.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)topRing[next].f_82479_, (float)topRing[next].f_82480_, (float)topRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)topRing[i].f_82479_, (float)topRing[i].f_82480_, (float)topRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            ++colorIndex;
        }
        for (i = 0; i < options.segments; ++i) {
            int next = (i + 1) % options.segments;
            if (options.renderFrontFaces) {
                if (!options.useMultiColor) {
                    c = options.color;
                    buffer.m_252986_(mat, (float)bottomCenter.f_82479_, (float)bottomCenter.f_82480_, (float)bottomCenter.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                } else {
                    buffer.m_252986_(mat, (float)bottomCenter.f_82479_, (float)bottomCenter.f_82480_, (float)bottomCenter.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                    ++colorIndex;
                }
            }
            if (!options.renderBackFaces) continue;
            if (!options.useMultiColor) {
                c = options.color;
                buffer.m_252986_(mat, (float)bottomCenter.f_82479_, (float)bottomCenter.f_82480_, (float)bottomCenter.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                continue;
            }
            buffer.m_252986_(mat, (float)bottomCenter.f_82479_, (float)bottomCenter.f_82480_, (float)bottomCenter.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)bottomRing[i].f_82479_, (float)bottomRing[i].f_82480_, (float)bottomRing[i].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            buffer.m_252986_(mat, (float)bottomRing[next].f_82479_, (float)bottomRing[next].f_82480_, (float)bottomRing[next].f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
            ++colorIndex;
        }
        tess.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderQuadColor(Matrix4f baseMat, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, RenderOptions options) {
        DColor c3;
        DColor c2;
        DColor c1;
        DColor c0;
        DColor c;
        Matrix4f mat = new Matrix4f((Matrix4fc)baseMat).mul((Matrix4fc)Renders.createTransformMatrix(options.offset, options.rotationDegrees, options.scale, options.pivot));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (options.renderFrontFaces) {
            if (!options.useMultiColor) {
                if (options.color == null) {
                    throw new IllegalArgumentException("renderQuadColor requires a color");
                }
                c = options.color;
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            } else {
                if (options.colors == null || options.colors.length < 4) {
                    throw new IllegalArgumentException("renderQuadColor must have exactly 4 colors");
                }
                c0 = options.colors[0];
                c1 = options.colors[1];
                c2 = options.colors[2];
                c3 = options.colors[3];
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c0.r(), c0.g(), c0.b(), c0.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c1.r(), c1.g(), c1.b(), c1.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c2.r(), c2.g(), c2.b(), c2.a()).m_5752_();
                buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(c3.r(), c3.g(), c3.b(), c3.a()).m_5752_();
            }
        }
        if (options.renderBackFaces) {
            if (!options.useMultiColor) {
                if (options.color == null) {
                    throw new IllegalArgumentException("renderQuadColor requires a color");
                }
                c = options.color;
                buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            } else {
                if (options.colors == null || options.colors.length < 4) {
                    throw new IllegalArgumentException("renderQuadColor must have exactly 4 colors");
                }
                c0 = options.colors[3];
                c1 = options.colors[2];
                c2 = options.colors[1];
                c3 = options.colors[0];
                buffer.m_252986_(mat, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(c0.r(), c0.g(), c0.b(), c0.a()).m_5752_();
                buffer.m_252986_(mat, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(c1.r(), c1.g(), c1.b(), c1.a()).m_5752_();
                buffer.m_252986_(mat, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(c2.r(), c2.g(), c2.b(), c2.a()).m_5752_();
                buffer.m_252986_(mat, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(c3.r(), c3.g(), c3.b(), c3.a()).m_5752_();
            }
        }
        tess.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderCircle2DColor(Matrix4f baseMat, RenderOptions options) {
        DColor c;
        float y;
        float x;
        double angle;
        if (options.segments < 3) {
            throw new IllegalArgumentException("Circle must have at least 3 segments");
        }
        if (options.radius <= 0.0f) {
            throw new IllegalArgumentException("Circle radius must be > 0");
        }
        Vec3 center = options.offset != null ? options.offset : new Vec3(0.0, 0.0, 0.0);
        float radius = options.radius;
        Matrix4f mat = new Matrix4f((Matrix4fc)baseMat).mul((Matrix4fc)Renders.createTransformMatrix(new Vec3(0.0, 0.0, 0.0), options.rotationDegrees, options.scale, options.pivot));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        DColor[] colors = null;
        int requiredColorsLength = options.segments + 1;
        if (options.useMultiColor) {
            if (options.colors == null || options.colors.length != requiredColorsLength) {
                throw new IllegalArgumentException("renderCircle2DColor requires colors length " + requiredColorsLength);
            }
            colors = options.colors;
        } else if (options.color == null) {
            throw new IllegalArgumentException("renderCircle2DColor requires a color");
        }
        if (options.renderFrontFaces) {
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            if (!options.useMultiColor) {
                c = options.color;
                buffer.m_252986_(mat, (float)center.f_82479_, (float)center.f_82480_, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            } else {
                c = colors[0];
                buffer.m_252986_(mat, (float)center.f_82479_, (float)center.f_82480_, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            }
            for (int i = 0; i <= options.segments; ++i) {
                angle = Math.PI * 2 * (double)i / (double)options.segments;
                x = (float)(center.f_82479_ + (double)radius * Math.cos(angle));
                y = (float)(center.f_82480_ + (double)radius * Math.sin(angle));
                if (!options.useMultiColor) {
                    c = options.color;
                    buffer.m_252986_(mat, x, y, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    continue;
                }
                c = colors[i + 1];
                buffer.m_252986_(mat, x, y, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            }
            tess.m_85914_();
        }
        if (options.renderBackFaces) {
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            if (!options.useMultiColor) {
                c = options.color;
                buffer.m_252986_(mat, (float)center.f_82479_, (float)center.f_82480_, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            } else {
                c = colors[0];
                buffer.m_252986_(mat, (float)center.f_82479_, (float)center.f_82480_, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            }
            for (int i = options.segments; i >= 0; --i) {
                angle = Math.PI * 2 * (double)i / (double)options.segments;
                x = (float)(center.f_82479_ + (double)radius * Math.cos(angle));
                y = (float)(center.f_82480_ + (double)radius * Math.sin(angle));
                if (!options.useMultiColor) {
                    c = options.color;
                    buffer.m_252986_(mat, x, y, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    continue;
                }
                c = colors[i + 1];
                buffer.m_252986_(mat, x, y, (float)center.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
            }
            tess.m_85914_();
        }
        RenderSystem.disableBlend();
    }

    public static void renderTorus(Matrix4f baseMat, RenderOptions options) {
        if (options.segments < 3) {
            throw new IllegalArgumentException("Torus must have at least 3 segments");
        }
        if (options.horizontalStripes < 3) {
            throw new IllegalArgumentException("Torus must have at least 3 horizontal stripes");
        }
        if (options.radius <= 0.0f) {
            throw new IllegalArgumentException("Torus major radius must be > 0");
        }
        if (options.minorRadius <= 0.0f) {
            throw new IllegalArgumentException("Torus minor radius must be > 0");
        }
        Vec3 center = options.offset != null ? options.offset : new Vec3(0.0, 0.0, 0.0);
        float majorRadius = options.radius;
        float minorRadius = options.minorRadius;
        Matrix4f mat = new Matrix4f((Matrix4fc)baseMat).mul((Matrix4fc)Renders.createTransformMatrix(new Vec3(0.0, 0.0, 0.0), options.rotationDegrees, options.scale, options.pivot));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        int facesCount = 0;
        if (options.renderFrontFaces) {
            ++facesCount;
        }
        if (options.renderBackFaces) {
            ++facesCount;
        }
        int requiredColorsLength = options.segments * options.horizontalStripes * 6 * facesCount;
        DColor[] colors = null;
        if (options.useMultiColor) {
            if (options.colors == null || options.colors.length != requiredColorsLength) {
                throw new IllegalArgumentException("renderTorus requires colors length " + requiredColorsLength);
            }
            colors = options.colors;
        } else if (options.color == null) {
            throw new IllegalArgumentException("renderTorus requires a color");
        }
        int colorIndex = 0;
        for (int i = 0; i < options.segments; ++i) {
            double u0 = Math.PI * 2 * (double)i / (double)options.segments;
            double u1 = Math.PI * 2 * (double)(i + 1) / (double)options.segments;
            for (int j = 0; j < options.horizontalStripes; ++j) {
                DColor c;
                double v0 = Math.PI * 2 * (double)j / (double)options.horizontalStripes;
                double v1 = Math.PI * 2 * (double)(j + 1) / (double)options.horizontalStripes;
                Vec3 vtx0 = new Vec3(center.f_82479_ + ((double)majorRadius + (double)minorRadius * Math.cos(v0)) * Math.cos(u0), center.f_82480_ + (double)minorRadius * Math.sin(v0), center.f_82481_ + ((double)majorRadius + (double)minorRadius * Math.cos(v0)) * Math.sin(u0));
                Vec3 vtx1 = new Vec3(center.f_82479_ + ((double)majorRadius + (double)minorRadius * Math.cos(v0)) * Math.cos(u1), center.f_82480_ + (double)minorRadius * Math.sin(v0), center.f_82481_ + ((double)majorRadius + (double)minorRadius * Math.cos(v0)) * Math.sin(u1));
                Vec3 vtx2 = new Vec3(center.f_82479_ + ((double)majorRadius + (double)minorRadius * Math.cos(v1)) * Math.cos(u1), center.f_82480_ + (double)minorRadius * Math.sin(v1), center.f_82481_ + ((double)majorRadius + (double)minorRadius * Math.cos(v1)) * Math.sin(u1));
                Vec3 vtx3 = new Vec3(center.f_82479_ + ((double)majorRadius + (double)minorRadius * Math.cos(v1)) * Math.cos(u0), center.f_82480_ + (double)minorRadius * Math.sin(v1), center.f_82481_ + ((double)majorRadius + (double)minorRadius * Math.cos(v1)) * Math.sin(u0));
                if (options.renderFrontFaces) {
                    if (!options.useMultiColor) {
                        c = options.color;
                        buffer.m_252986_(mat, (float)vtx0.f_82479_, (float)vtx0.f_82480_, (float)vtx0.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx1.f_82479_, (float)vtx1.f_82480_, (float)vtx1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx2.f_82479_, (float)vtx2.f_82480_, (float)vtx2.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx0.f_82479_, (float)vtx0.f_82480_, (float)vtx0.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx2.f_82479_, (float)vtx2.f_82480_, (float)vtx2.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx3.f_82479_, (float)vtx3.f_82480_, (float)vtx3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    } else {
                        buffer.m_252986_(mat, (float)vtx0.f_82479_, (float)vtx0.f_82480_, (float)vtx0.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx1.f_82479_, (float)vtx1.f_82480_, (float)vtx1.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx2.f_82479_, (float)vtx2.f_82480_, (float)vtx2.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx0.f_82479_, (float)vtx0.f_82480_, (float)vtx0.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx2.f_82479_, (float)vtx2.f_82480_, (float)vtx2.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        buffer.m_252986_(mat, (float)vtx3.f_82479_, (float)vtx3.f_82480_, (float)vtx3.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                        ++colorIndex;
                    }
                }
                if (!options.renderBackFaces) continue;
                if (!options.useMultiColor) {
                    c = options.color;
                    buffer.m_252986_(mat, (float)vtx3.f_82479_, (float)vtx3.f_82480_, (float)vtx3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)vtx2.f_82479_, (float)vtx2.f_82480_, (float)vtx2.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)vtx1.f_82479_, (float)vtx1.f_82480_, (float)vtx1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)vtx3.f_82479_, (float)vtx3.f_82480_, (float)vtx3.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)vtx1.f_82479_, (float)vtx1.f_82480_, (float)vtx1.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    buffer.m_252986_(mat, (float)vtx0.f_82479_, (float)vtx0.f_82480_, (float)vtx0.f_82481_).m_85950_(c.r(), c.g(), c.b(), c.a()).m_5752_();
                    continue;
                }
                buffer.m_252986_(mat, (float)vtx3.f_82479_, (float)vtx3.f_82480_, (float)vtx3.f_82481_).m_85950_(colors[colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)vtx2.f_82479_, (float)vtx2.f_82480_, (float)vtx2.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)vtx1.f_82479_, (float)vtx1.f_82480_, (float)vtx1.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)vtx3.f_82479_, (float)vtx3.f_82480_, (float)vtx3.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)vtx1.f_82479_, (float)vtx1.f_82480_, (float)vtx1.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                buffer.m_252986_(mat, (float)vtx0.f_82479_, (float)vtx0.f_82480_, (float)vtx0.f_82481_).m_85950_(colors[++colorIndex].r(), colors[colorIndex].g(), colors[colorIndex].b(), colors[colorIndex].a()).m_5752_();
                ++colorIndex;
            }
        }
        tess.m_85914_();
        RenderSystem.disableBlend();
    }
}

