/*
 * Decompiled with CFR 0.152.
 */
package del.mod.dlib.types;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SmoothPath {
    private final List<Key> keys = new ArrayList<Key>();

    public void add(double time, Vector3f pos, Vector3f rot) {
        this.keys.add(new Key(time, new Vector3f((Vector3fc)pos), new Vector3f((Vector3fc)rot)));
        this.keys.sort(Comparator.comparingDouble(k -> k.t));
    }

    private Vector3f hermite(Vector3f p0, Vector3f p1, Vector3f m0, Vector3f m1, float t) {
        float tt = t * t;
        float ttt = tt * t;
        float h00 = 2.0f * ttt - 3.0f * tt + 1.0f;
        float h10 = ttt - 2.0f * tt + t;
        float h01 = -2.0f * ttt + 3.0f * tt;
        float h11 = ttt - tt;
        return new Vector3f(h00 * p0.x + h10 * m0.x + h01 * p1.x + h11 * m1.x, h00 * p0.y + h10 * m0.y + h01 * p1.y + h11 * m1.y, h00 * p0.z + h10 * m0.z + h01 * p1.z + h11 * m1.z);
    }

    private Vector3f tangent(int i) {
        if (i == 0) {
            return new Vector3f((Vector3fc)this.keys.get((int)1).p).sub((Vector3fc)this.keys.get((int)0).p);
        }
        if (i == this.keys.size() - 1) {
            return new Vector3f((Vector3fc)this.keys.get((int)i).p).sub((Vector3fc)this.keys.get((int)(i - 1)).p);
        }
        Vector3f a = new Vector3f((Vector3fc)this.keys.get((int)(i + 1)).p).sub((Vector3fc)this.keys.get((int)(i - 1)).p);
        return a.mul(0.5f);
    }

    public Vector3f getPosition(double time) {
        if (this.keys.isEmpty()) {
            return new Vector3f();
        }
        if (time <= this.keys.get((int)0).t) {
            return new Vector3f((Vector3fc)this.keys.get((int)0).p);
        }
        if (time >= this.keys.get((int)(this.keys.size() - 1)).t) {
            return new Vector3f((Vector3fc)this.keys.get((int)(this.keys.size() - 1)).p);
        }
        for (int i = 0; i < this.keys.size() - 1; ++i) {
            Key a = this.keys.get(i);
            Key b = this.keys.get(i + 1);
            if (!(time >= a.t) || !(time <= b.t)) continue;
            float t = (float)((time - a.t) / (b.t - a.t));
            Vector3f m0 = this.tangent(i);
            Vector3f m1 = this.tangent(i + 1);
            return this.hermite(a.p, b.p, m0, m1, t);
        }
        return new Vector3f((Vector3fc)this.keys.get((int)(this.keys.size() - 1)).p);
    }

    public Vector3f getRotation(double time) {
        if (this.keys.isEmpty()) {
            return new Vector3f();
        }
        if (time <= this.keys.get((int)0).t) {
            return new Vector3f((Vector3fc)this.keys.get((int)0).r);
        }
        if (time >= this.keys.get((int)(this.keys.size() - 1)).t) {
            return new Vector3f((Vector3fc)this.keys.get((int)(this.keys.size() - 1)).r);
        }
        for (int i = 0; i < this.keys.size() - 1; ++i) {
            Key a = this.keys.get(i);
            Key b = this.keys.get(i + 1);
            if (!(time >= a.t) || !(time <= b.t)) continue;
            float t = (float)((time - a.t) / (b.t - a.t));
            return new Vector3f(a.r.x + (b.r.x - a.r.x) * t, a.r.y + (b.r.y - a.r.y) * t, a.r.z + (b.r.z - a.r.z) * t);
        }
        return new Vector3f((Vector3fc)this.keys.get((int)(this.keys.size() - 1)).r);
    }

    private static class Key {
        double t;
        Vector3f p;
        Vector3f r;

        Key(double t, Vector3f p, Vector3f r) {
            this.t = t;
            this.p = p;
            this.r = r;
        }
    }
}

