/*
 * Decompiled with CFR 0.152.
 */
package borknbeans.lightweightinventorysorting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SortSnapshotServerside {
    public List<class_1799> inventory;

    public SortSnapshotServerside decode(String compressedData) {
        try {
            int len;
            byte[] decoded = Base64.getDecoder().decode(compressedData);
            ByteArrayInputStream bais = new ByteArrayInputStream(decoded);
            GZIPInputStream gzipIn = new GZIPInputStream(bais);
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = gzipIn.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            gzipIn.close();
            String json = baos.toString();
            Gson gson = new GsonBuilder().registerTypeAdapter(class_1799.class, (Object)new ItemStackDeserializer()).create();
            return (SortSnapshotServerside)gson.fromJson(json, SortSnapshotServerside.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decompress inventory data", e);
        }
    }

    private static class ItemStackDeserializer
    implements JsonDeserializer<class_1799> {
        private ItemStackDeserializer() {
        }

        public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("empty") && obj.get("empty").getAsBoolean()) {
                return class_1799.field_8037;
            }
            String id = obj.get("id").getAsString();
            int count = obj.get("count").getAsInt();
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)id));
            class_1799 stack = new class_1799((class_1935)item);
            stack.method_7939(count);
            return stack;
        }
    }
}

