/*
 * Decompiled with CFR 0.152.
 */
package borknbeans.lightweightinventorysorting.sorting;

import borknbeans.lightweightinventorysorting.LightweightInventorySorting;
import borknbeans.lightweightinventorysorting.config.Config;
import borknbeans.lightweightinventorysorting.sorting.ClickOperation;
import borknbeans.lightweightinventorysorting.sorting.SortComparator;
import borknbeans.lightweightinventorysorting.sorting.SortSnapshotClientside;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_5537;

@Environment(value=EnvType.CLIENT)
public class Sorter {
    private static boolean isSorting = false;

    public static void sortContainerClientside(class_310 client, int sortStartIndex, int sortEndIndex) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        if (isSorting) {
            return;
        }
        isSorting = true;
        LightweightInventorySorting.LOGGER.info("Starting clientside sort");
        int syncId = client.field_1724.field_7512.field_7763;
        List<class_1799> snapshot = Sorter.getInventorySnapshot(client, sortStartIndex, sortEndIndex);
        SortSnapshotClientside snapshotEncoder = new SortSnapshotClientside(snapshot);
        LightweightInventorySorting.LOGGER.info("Encoded snapshot: " + snapshotEncoder.encode());
        new Thread(() -> {
            try {
                Sorter.clearMouseStack(client, syncId, sortStartIndex, sortEndIndex);
                Sorter.combineLikeStacks(client, syncId, sortStartIndex, sortEndIndex);
                Sorter.sort(client, syncId, sortStartIndex, sortEndIndex);
                LightweightInventorySorting.LOGGER.info("Clientside sort complete");
            }
            catch (Exception e) {
                LightweightInventorySorting.LOGGER.error(e.getMessage());
            }
            isSorting = false;
        }).start();
    }

    private static void clearMouseStack(class_310 client, int syncId, int sortStartIndex, int sortEndIndex) throws Exception {
        List<class_1799> snapshot = Sorter.getInventorySnapshot(client, sortStartIndex, sortEndIndex);
        class_1799 mouseStack = Sorter.getMouseStack(client).method_7972();
        if (!mouseStack.method_7960()) {
            int emptyIndex = Sorter.getEmptySlotIndex(snapshot);
            if (emptyIndex == -1) {
                throw new Exception("[Sort] No empty slot found to clear mouse stack");
            }
            ClickOperation emptySlotOperation = new ClickOperation(client, syncId, sortStartIndex + emptyIndex, class_1799.field_8037, mouseStack, mouseStack, class_1799.field_8037);
            emptySlotOperation.execute();
        }
    }

    private static void combineLikeStacks(class_310 client, int syncId, int sortStartIndex, int sortEndIndex) throws Exception {
        List<class_1799> snapshot = Sorter.getInventorySnapshot(client, sortStartIndex, sortEndIndex);
        class_1799 mouseStack = Sorter.getMouseStack(client);
        if (!mouseStack.method_7960()) {
            throw new Exception("[CombineLikeStacks] Mouse stack is not empty");
        }
        for (int i = 0; i < snapshot.size(); ++i) {
            class_1799 stackOriginal = snapshot.get(i).method_7972();
            mouseStack = Sorter.getMouseStack(client);
            if (stackOriginal.method_7960() || stackOriginal.method_7947() == stackOriginal.method_7914()) continue;
            for (int j = i + 1; j < snapshot.size(); ++j) {
                class_1799 stack;
                class_1799 otherStack = snapshot.get(j).method_7972();
                if (otherStack.method_7960() || otherStack.method_7947() == otherStack.method_7914()) continue;
                class_1799 class_17992 = stack = mouseStack.method_7960() ? stackOriginal : mouseStack;
                if (!class_1799.method_31577((class_1799)stack, (class_1799)otherStack)) continue;
                int maxStackSize = stack.method_7914();
                int combinedSize = stack.method_7947() + otherStack.method_7947();
                ClickOperation pickupFirstStack = new ClickOperation(client, syncId, i + sortStartIndex, stack, class_1799.field_8037, mouseStack, stack);
                class_1799 expectedEndingMouseStack = combinedSize > maxStackSize ? stack.method_46651(combinedSize - maxStackSize) : class_1799.field_8037;
                ClickOperation combineStacks = new ClickOperation(client, syncId, j + sortStartIndex, otherStack, stack.method_46651(Math.min(combinedSize, maxStackSize)), stack, expectedEndingMouseStack);
                try {
                    if (mouseStack.method_7960()) {
                        pickupFirstStack.execute();
                    }
                    Thread.sleep(Config.sortDelay);
                    combineStacks.execute();
                }
                catch (Exception e) {
                    throw new Exception("Failed to combine like items: " + e.getMessage());
                }
                mouseStack = expectedEndingMouseStack;
                if (mouseStack.method_7960()) break;
            }
            if (!mouseStack.method_7960()) {
                ClickOperation putBackStack = new ClickOperation(client, syncId, i + sortStartIndex, class_1799.field_8037, mouseStack, mouseStack, class_1799.field_8037);
                try {
                    putBackStack.execute();
                }
                catch (Exception e) {
                    throw new Exception("Failed to put back item: " + e.getMessage());
                }
            }
            snapshot = Sorter.getInventorySnapshot(client, sortStartIndex, sortEndIndex);
        }
    }

    private static void sort(class_310 client, int syncId, int sortStartIndex, int sortEndIndex) throws Exception {
        int i;
        List<class_1799> snapshot = Sorter.getInventorySnapshot(client, sortStartIndex, sortEndIndex);
        ArrayList<class_1799> sortedStacks = new ArrayList<class_1799>();
        for (int i2 = 0; i2 < snapshot.size(); ++i2) {
            class_1799 stack = snapshot.get(i2).method_7972();
            if (stack.method_7960()) continue;
            sortedStacks.add(stack);
        }
        sortedStacks.sort(new SortComparator());
        class_1799 mouseStack = Sorter.getMouseStack(client);
        if (!mouseStack.method_7960()) {
            throw new Exception("[Sort] Mouse stack is not empty");
        }
        for (i = 0; i < sortedStacks.size(); ++i) {
            class_1799 sortedStack = (class_1799)sortedStacks.get(i);
            int stackCurrIndex = -1;
            for (int j = i; j < snapshot.size(); ++j) {
                if (!class_1799.method_31577((class_1799)sortedStack, (class_1799)snapshot.get(j)) || sortedStack.method_7947() != snapshot.get(j).method_7947()) continue;
                stackCurrIndex = j + sortStartIndex;
                break;
            }
            if (stackCurrIndex == -1) {
                throw new Exception("[Sort] Stack not found in inventory, looking for: " + sortedStack.toString());
            }
            if (stackCurrIndex == i + sortStartIndex) continue;
            ClickOperation pickupOperation = new ClickOperation(client, syncId, stackCurrIndex, sortedStack, class_1799.field_8037, class_1799.field_8037, sortedStack);
            class_1799 existingStack = snapshot.get(i).method_7972();
            if (existingStack.method_7909() instanceof class_5537) {
                ClickOperation pickupBundleOperation = new ClickOperation(client, syncId, i + sortStartIndex, existingStack, class_1799.field_8037, class_1799.field_8037, existingStack);
                ClickOperation placeBundleElsewhereOperation = new ClickOperation(client, syncId, Sorter.getEmptySlotIndex(snapshot) + sortStartIndex, class_1799.field_8037, existingStack, existingStack, class_1799.field_8037);
                pickupBundleOperation.execute();
                placeBundleElsewhereOperation.execute();
                existingStack = class_1799.field_8037;
            }
            ClickOperation placeOperation = new ClickOperation(client, syncId, i + sortStartIndex, existingStack, sortedStack, sortedStack, existingStack);
            ClickOperation emptyHandOperation = new ClickOperation(client, syncId, stackCurrIndex, class_1799.field_8037, existingStack, existingStack, class_1799.field_8037);
            if (sortedStack.method_7909() instanceof class_5537 && !existingStack.method_7960()) {
                ClickOperation pickupTargetSlotOperation = new ClickOperation(client, syncId, i + sortStartIndex, existingStack, class_1799.field_8037, class_1799.field_8037, existingStack);
                int emptySlotIndex = Sorter.getEmptySlotIndex(snapshot);
                if (emptySlotIndex == -1) {
                    throw new Exception("[Sort] No empty slot found");
                }
                ClickOperation placeInEmptySlotOperation = new ClickOperation(client, syncId, sortStartIndex + emptySlotIndex, class_1799.field_8037, existingStack, existingStack, class_1799.field_8037);
                pickupTargetSlotOperation.execute();
                placeInEmptySlotOperation.execute();
                Thread.sleep(Config.sortDelay);
                existingStack = class_1799.field_8037;
                placeOperation = new ClickOperation(client, syncId, i + sortStartIndex, existingStack, sortedStack, sortedStack, existingStack);
            }
            pickupOperation.execute();
            placeOperation.execute();
            Thread.sleep(Config.sortDelay);
            if (!existingStack.method_7960()) {
                emptyHandOperation.execute();
            }
            snapshot = Sorter.getInventorySnapshot(client, sortStartIndex, sortEndIndex);
        }
        for (i = 0; i < sortedStacks.size(); ++i) {
            class_1799 actualStack;
            class_1799 expectedStack = ((class_1799)sortedStacks.get(i)).method_7972();
            if (class_1799.method_31577((class_1799)expectedStack, (class_1799)(actualStack = snapshot.get(i).method_7972()))) continue;
            throw new Exception("[Sort] Stack not in correct position");
        }
    }

    private static List<class_1799> getInventorySnapshot(class_310 client, int sortStartIndex, int sortEndIndex) {
        class_2371 slots = client.field_1724.field_7512.field_7761;
        ArrayList<class_1799> snapshot = new ArrayList<class_1799>();
        for (int i = 0; i < slots.size(); ++i) {
            if (i < sortStartIndex || i > sortEndIndex) continue;
            snapshot.add(((class_1735)slots.get(i)).method_7677());
        }
        return snapshot;
    }

    private static int getEmptySlotIndex(List<class_1799> snapshot) {
        for (int i = 0; i < snapshot.size(); ++i) {
            if (!snapshot.get(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public static class_1799 getInventoryStack(class_310 client, int index) {
        if (client.field_1724 == null) {
            return class_1799.field_8037;
        }
        return client.field_1724.field_7512.method_7611(index).method_7677();
    }

    public static class_1799 getMouseStack(class_310 client) {
        if (client.field_1724 == null) {
            return class_1799.field_8037;
        }
        return client.field_1724.field_7512.method_34255();
    }
}

