/*
 * Decompiled with CFR 0.152.
 */
package io.github.real_septicake.hexxyplanes;

import io.github.real_septicake.hexxyplanes.HexplaneExit;
import io.github.real_septicake.hexxyplanes.Hexxyplanes;
import io.github.real_septicake.hexxyplanes.HexxyplanesAbstractions;
import io.github.real_septicake.hexxyplanes.registry.HexxyplanesBlocks;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R;\u0010\u001c\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00100\u0010 \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u001a0\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lio/github/real_septicake/hexxyplanes/HexxyplanesDimension;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/server/level/ServerPlayer;", "by", "Lnet/minecraft/world/entity/Entity;", "entity", "", "banishFromPlane", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/Entity;)V", "player", "exitPlane", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/minecraft/world/level/Level;", "Ljava/util/UUID;", "uuid", "repairPlane", "(Lnet/minecraft/world/level/Level;Ljava/util/UUID;)V", "sendToPlane", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Ljava/util/UUID;)V", "", "PLANE_SIZE", "I", "Lnet/minecraft/resources/ResourceKey;", "kotlin.jvm.PlatformType", "WORLD_KEY", "Lnet/minecraft/resources/ResourceKey;", "getWORLD_KEY", "()Lnet/minecraft/resources/ResourceKey;", "hexxyplanes-common"})
public final class HexxyplanesDimension {
    @NotNull
    public static final HexxyplanesDimension INSTANCE = new HexxyplanesDimension();
    private static final ResourceKey<Level> WORLD_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)Hexxyplanes.id("hexplane"));
    public static final int PLANE_SIZE = 16;

    private HexxyplanesDimension() {
    }

    public final ResourceKey<Level> getWORLD_KEY() {
        return WORLD_KEY;
    }

    public final void repairPlane(@NotNull Level world, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ChunkPos chunkPos = Hexxyplanes.chunkFromUUID(uuid);
        int n = chunkPos.m_45604_() + 16;
        for (int x = chunkPos.m_45604_(); x < n; ++x) {
            for (int y = 0; y < 16; ++y) {
                int n2 = chunkPos.m_45605_() + 16;
                for (int z = chunkPos.m_45605_(); z < n2; ++z) {
                    BlockPos block = new BlockPos(x, y, z);
                    if (x == chunkPos.m_45604_() || x == chunkPos.m_45604_() + 16 - 1 || y == 0 || y == 15 || z == chunkPos.m_45605_() || z == chunkPos.m_45605_() + 16 - 1) {
                        world.m_7731_(block, HexxyplanesBlocks.INSTANCE.getBARRIER().getBlock().m_49966_(), 3);
                        continue;
                    }
                    BlockState bs = world.m_8055_(block);
                    if (!bs.m_60713_((Block)HexxyplanesBlocks.INSTANCE.getBARRIER().getBlock()) && !bs.m_60713_((Block)HexxyplanesBlocks.INSTANCE.getBARRIER_SPAWN().getBlock())) continue;
                    world.m_7731_(block, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
        world.m_7731_(new BlockPos(chunkPos.m_45604_() + 1, 0, chunkPos.m_45605_() + 1), HexxyplanesBlocks.INSTANCE.getBARRIER_SPAWN().getBlock().m_49966_(), 3);
        world.m_46961_(new BlockPos(chunkPos.m_45604_() + 1, 1, chunkPos.m_45605_() + 1), true);
        world.m_46961_(new BlockPos(chunkPos.m_45604_() + 1, 2, chunkPos.m_45605_() + 1), true);
    }

    public final void sendToPlane(@NotNull ServerLevel world, @NotNull Entity entity, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.repairPlane((Level)world, uuid);
        ChunkPos chunkPos = Hexxyplanes.chunkFromUUID(uuid);
        entity.m_264318_(world, (double)chunkPos.m_45604_() + 1.5, 1.0, (double)chunkPos.m_45605_() + 1.5, SetsKt.emptySet(), -45.0f, 0.0f);
    }

    public final void banishFromPlane(@NotNull ServerLevel world, @NotNull ServerPlayer by, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof ServerPlayer) {
            this.exitPlane(world, (ServerPlayer)entity);
        } else {
            HexplaneExit hexplaneExit = HexxyplanesAbstractions.getExit((Player)by);
            if (hexplaneExit == null) {
                ResourceKey resourceKey = by.m_8963_();
                BlockPos blockPos = by.m_8961_();
                if (blockPos == null) {
                    blockPos = world.m_220360_();
                }
                hexplaneExit = new HexplaneExit((ResourceKey<Level>)resourceKey, blockPos);
            }
            HexplaneExit exit = hexplaneExit;
            ServerLevel serverLevel = world.m_7654_().m_129880_(exit.dimension);
            Intrinsics.checkNotNull((Object)serverLevel);
            entity.m_264318_(serverLevel, (double)exit.position.m_123341_(), (double)exit.position.m_123342_(), (double)exit.position.m_123343_(), SetsKt.emptySet(), 0.0f, 0.0f);
        }
    }

    public final void exitPlane(@NotNull ServerLevel world, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HexplaneExit exit = HexxyplanesAbstractions.getExit((Player)player);
        if (exit != null) {
            ServerLevel serverLevel = world.m_7654_().m_129880_(exit.dimension);
            Intrinsics.checkNotNull((Object)serverLevel);
            ServerLevel dim = serverLevel;
            Vec3 pos = exit.position.m_252807_();
            player.m_8999_(dim, pos.f_82479_, pos.f_82480_ - 0.5, pos.f_82481_, 0.0f, 0.0f);
            return;
        }
        BlockPos blockPos = player.m_8961_();
        if (blockPos == null) {
            blockPos = world.m_7654_().m_129783_().m_220360_();
        }
        Vec3 dest = blockPos.m_252807_();
        ResourceKey dim = player.m_8963_();
        if (world.m_7654_().m_129880_(dim) == null) {
            dest = world.m_7654_().m_129783_().m_220360_().m_252807_();
            dim = Level.f_46428_;
        }
        if (Intrinsics.areEqual((Object)dim, WORLD_KEY)) {
            player.m_213846_((Component)Component.m_237115_((String)"hexxyplanes.error.bad_respawn").m_130940_(ChatFormatting.BOLD));
            dest = world.m_7654_().m_129783_().m_220360_().m_252807_();
            player.m_8999_(world.m_7654_().m_129783_(), dest.f_82479_, dest.f_82480_ - 0.5, dest.f_82481_, player.m_8962_(), 0.0f);
        } else {
            ServerLevel serverLevel = world.m_7654_().m_129880_(dim);
            Intrinsics.checkNotNull((Object)serverLevel);
            player.m_8999_(serverLevel, dest.f_82479_, dest.f_82480_ - 0.5, dest.f_82481_, player.m_8962_(), 0.0f);
        }
    }
}

