/*
 * Decompiled with CFR 0.152.
 */
package io.github.real_septicake.hexxyplanes.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadCaster;
import at.petrak.hexcasting.api.casting.mishaps.MishapImmuneEntity;
import at.petrak.hexcasting.api.mod.HexTags;
import io.github.real_septicake.hexxyplanes.HexxyplanesDimension;
import io.github.real_septicake.hexxyplanes.UtilsKt;
import io.github.real_septicake.hexxyplanes.casting.iota.PlaneIota;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lio/github/real_septicake/hexxyplanes/casting/actions/spells/OpEnterPlane;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "<init>", "()V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "", "argc", "I", "getArgc", "()I", "Spell", "hexxyplanes-common"})
public final class OpEnterPlane
implements SpellAction {
    @NotNull
    public static final OpEnterPlane INSTANCE = new OpEnterPlane();
    private static final int argc = 2;

    private OpEnterPlane() {
    }

    public int getArgc() {
        return argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        PlaneIota dest = UtilsKt.getPlane(args, 0, this.getArgc());
        Entity target = OperatorUtils.getEntity(args, (int)1, (int)this.getArgc());
        if (!(env.getCastingEntity() instanceof ServerPlayer)) {
            throw new MishapBadCaster();
        }
        if (!target.m_6072_() || target.m_6095_().m_204039_(HexTags.Entities.CANNOT_TELEPORT)) {
            throw new MishapImmuneEntity(target);
        }
        UUID uUID = dest.getPlayer().m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return new SpellAction.Result((RenderedSpell)new Spell(uUID, target), Intrinsics.areEqual(HexxyplanesDimension.INSTANCE.getWORLD_KEY(), (Object)target.m_9236_().m_46472_()) ? 50000L : 500000L, CollectionsKt.emptyList(), 0L, 8, null);
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (CompoundTag)userData);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J$\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\u000e\u00a8\u0006\""}, d2={"Lio/github/real_septicake/hexxyplanes/casting/actions/spells/OpEnterPlane$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/world/entity/Entity;", "target", "<init>", "(Ljava/util/UUID;Lnet/minecraft/world/entity/Entity;)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "component1", "()Ljava/util/UUID;", "component2", "()Lnet/minecraft/world/entity/Entity;", "copy", "(Ljava/util/UUID;Lnet/minecraft/world/entity/Entity;)Lio/github/real_septicake/hexxyplanes/casting/actions/spells/OpEnterPlane$Spell;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/world/entity/Entity;", "getTarget", "Ljava/util/UUID;", "getUuid", "hexxyplanes-common"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final UUID uuid;
        @NotNull
        private final Entity target;

        public Spell(@NotNull UUID uuid, @NotNull Entity target) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.uuid = uuid;
            this.target = target;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final Entity getTarget() {
            return this.target;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            ServerLevel serverLevel = env.getWorld().m_7654_().m_129880_(HexxyplanesDimension.INSTANCE.getWORLD_KEY());
            Intrinsics.checkNotNull((Object)serverLevel);
            HexxyplanesDimension.INSTANCE.sendToPlane(serverLevel, this.target, this.uuid);
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final Entity component2() {
            return this.target;
        }

        @NotNull
        public final Spell copy(@NotNull UUID uuid, @NotNull Entity target) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(uuid, target);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, UUID uUID, Entity entity, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = spell.uuid;
            }
            if ((n & 2) != 0) {
                entity = spell.target;
            }
            return spell.copy(uUID, entity);
        }

        @NotNull
        public String toString() {
            return "Spell(uuid=" + this.uuid + ", target=" + this.target + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.target.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)spell.uuid)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)spell.target);
        }
    }
}

