/*
 * Decompiled with CFR 0.152.
 */
package net.gamercave.thecursedmod.block;

import java.util.function.Supplier;
import net.gamercave.thecursedmod.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thecursedmod");
    public static final RegistryObject<Block> CURSED_BLOCK = ModBlocks.registerBlock("cursed_block", () -> new Block(BlockBehaviour.Properties.of().strength(1.0f).destroyTime(3.0f).sound(SoundType.ANVIL)));
    public static final RegistryObject<Block> FREDBEAR_BLOCK = ModBlocks.registerBlock("fredbear_block", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f).destroyTime(6.0f).sound(SoundType.ANVIL)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

